/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.notification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.Letter;

class NotificationCacheEntry {
    private String id;
    private Map<Folder, List<Letter>> session;
    private Map<Folder, List<Letter>> last;
    private String error;

    public NotificationCacheEntry(String string) {
        this.id = string;
        this.session = new HashMap<Folder, List<Letter>>();
        this.last = new HashMap<Folder, List<Letter>>();
    }

    public void put(Folder folder, List<Letter> list) {
        if (this.session.containsKey(folder)) {
            this.session.get(folder).addAll(list);
        } else {
            this.session.put(folder, list);
        }
    }

    public void put(Map<Folder, List<Letter>> map) {
        if (this.session.isEmpty()) {
            this.session.putAll(map);
            this.last.putAll(map);
            return;
        }
        this.last.clear();
        for (Folder folder : map.keySet()) {
            if (!this.session.containsKey(folder)) {
                this.session.put(folder, map.get(folder));
                this.last.put(folder, map.get(folder));
                continue;
            }
            for (Letter letter : map.get(folder)) {
                if (this.session.get(folder).contains(letter)) continue;
                this.session.get(folder).add(letter);
                if (!this.last.containsKey(folder)) {
                    this.last.put(folder, new ArrayList());
                }
                this.last.get(folder).add(letter);
            }
        }
    }

    public void remove(Folder folder, String string) {
        Iterator<Letter> iterator = this.session.get(folder).iterator();
        while (iterator.hasNext()) {
            Letter letter = iterator.next();
            if (!letter.getUid().equals(string)) continue;
            iterator.remove();
            break;
        }
    }

    public void remove(Folder folder) {
        this.session.remove(folder);
        this.last.remove(folder);
    }

    public boolean isEmpty() {
        return this.session.isEmpty();
    }

    public void clear() {
        this.error = null;
        this.session.clear();
        this.last.clear();
    }

    public synchronized List<Letter> get(Folder folder) {
        if (!this.session.containsKey(folder)) {
            this.session.put(folder, new ArrayList());
        }
        return this.session.get(folder);
    }

    public Letter get(Folder folder, String string) {
        for (Letter letter : this.get(folder)) {
            if (!letter.getMessageID().equals(string)) continue;
            return letter;
        }
        return null;
    }

    public Letter get(String string) {
        for (Folder folder : this.session.keySet()) {
            for (Letter letter : this.session.get(folder)) {
                if (!letter.getMessageID().equals(string)) continue;
                return letter;
            }
        }
        return null;
    }

    public List<Letter> get(boolean bl) {
        ArrayList<Letter> arrayList = new ArrayList<Letter>();
        for (Folder folder : this.session.keySet()) {
            for (Letter letter : this.session.get(folder)) {
                boolean bl2 = letter.isFetched();
                if (bl && bl2) {
                    arrayList.add(letter);
                    continue;
                }
                if (bl || bl2) continue;
                arrayList.add(letter);
            }
        }
        return arrayList;
    }

    public int getLastCount() {
        return this.getLetterCount(this.last);
    }

    public int getSessionCount() {
        return this.getLetterCount(this.session);
    }

    private int getLetterCount(Map<Folder, List<Letter>> map) {
        int n = 0;
        for (Folder folder : map.keySet()) {
            n += map.get(folder).size();
        }
        return n;
    }

    public void setError(String string) {
        this.error = string;
    }

    public String getError() {
        return this.error;
    }

    public String getId() {
        return this.id;
    }

    public Map<Folder, List<Letter>> getSession() {
        return Collections.unmodifiableMap(this.session);
    }

    public boolean contains(Folder folder) {
        return this.session.containsKey(folder);
    }
}

