/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.app.state;

import java.util.Observable;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.account.AccountCacheEvent;
import net.sf.amemailchecker.app.notification.NotificationCache;
import net.sf.amemailchecker.app.notification.NotificationCacheEvent;
import net.sf.amemailchecker.app.state.State;
import net.sf.amemailchecker.util.GenericObserver;

public class StateContext
extends Observable {
    private NotificationCacheObserver notificationCacheObserver = new NotificationCacheObserver();
    private AccountCacheObserver accountCacheObserver = new AccountCacheObserver();
    private State currentState = State.NONE;

    public State getCurrentState() {
        return this.currentState;
    }

    private void setCurrentState(State state) {
        this.currentState = state;
        this.fireObserverUpdate();
    }

    private void fireObserverUpdate() {
        this.setChanged();
        this.notifyObservers();
    }

    public void stateChanged() {
        boolean bl;
        boolean bl2 = ApplicationContext.getInstance().getAccountsCache().hasActive();
        int n = NotificationCache.getInstance().getPersistedCountTotal();
        boolean bl3 = bl = n > 0;
        if (!bl2) {
            this.setCurrentState(bl ? State.UNREAD_INACTIVE : State.NORMAL_INACTIVE);
        } else {
            this.setCurrentState(bl ? State.UNREAD : State.NORMAL);
        }
    }

    public void mailCheckingStarted() {
        boolean bl = ApplicationContext.getInstance().getAccountsCache().hasActive();
        if (bl) {
            this.setCurrentState(State.CHECKING);
        }
    }

    public void mailCheckingFinished() {
        if (NotificationCache.getInstance().isError()) {
            this.setCurrentState(State.ERROR);
        } else {
            this.stateChanged();
        }
    }

    public NotificationCacheObserver getNotificationCacheObserver() {
        return this.notificationCacheObserver;
    }

    public AccountCacheObserver getAccountCacheObserver() {
        return this.accountCacheObserver;
    }

    private class AccountCacheObserver
    implements GenericObserver<AccountCacheEvent> {
        private AccountCacheObserver() {
        }

        public void updatePerformed(AccountCacheEvent accountCacheEvent) {
            if (!StateContext.this.currentState.equals((Object)State.CHECKING)) {
                StateContext.this.stateChanged();
            }
        }
    }

    private class NotificationCacheObserver
    implements GenericObserver<NotificationCacheEvent> {
        private NotificationCacheObserver() {
        }

        public void updatePerformed(NotificationCacheEvent notificationCacheEvent) {
            if (!StateContext.this.currentState.equals((Object)State.CHECKING)) {
                StateContext.this.stateChanged();
            }
        }
    }
}

