/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command;

import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.command.CommandExecutionEvent;
import net.sf.amemailchecker.command.ICommand;
import net.sf.amemailchecker.command.exception.CommandExecutionException;
import net.sf.amemailchecker.command.task.CommandExecutableTask;
import net.sf.amemailchecker.command.task.ExecutableTask;
import net.sf.amemailchecker.util.GenericObservable;
import net.sf.amemailchecker.util.GenericObserver;

public enum CommandExecutionService {
    Service;

    private static final Logger logger;
    private final Object commandListLock = new Object();
    private final Object silentExecutionLock = new Object();
    private List<ICommand> submittedCommands = new Vector<ICommand>();
    private GenericObserver commandObserver = new CommandObserver();
    private GenericObserver notifyObserver = new NotifyObserver();
    private CommandExecutionObservable commandExecutionObservable = new CommandExecutionObservable();

    public void addCommandExecutionObserver(GenericObserver<CommandExecutionEvent> genericObserver) {
        this.commandExecutionObservable.addObserver(genericObserver);
    }

    public void executeRegister(ExecutableTask executableTask) {
        this.submittedCommands.add(executableTask.getCommand());
        executableTask.addExecutableObserver(this.commandObserver);
        this.execute(executableTask);
    }

    public void executeNotify(ExecutableTask executableTask) {
        this.commandExecutionObservable.fireObserverUpdate(new CommandExecutionEvent(CommandExecutionEvent.CommandExecutionEventType.STARTED, executableTask.getExecutable()));
        executableTask.addExecutableObserver(this.notifyObserver);
        this.executeRegister(executableTask);
    }

    public void execute(ExecutableTask executableTask) {
        new Thread(executableTask).start();
    }

    public void executeCommandSilent(final ICommand iCommand) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CommandExecutionService.this.silentExecutionLock;
                synchronized (object) {
                    try {
                        iCommand.execute();
                    }
                    catch (CommandExecutionException commandExecutionException) {
                        CommandExecutionService.this.logError(commandExecutionException, iCommand);
                    }
                }
            }
        }.start();
    }

    private void logError(Throwable throwable, ICommand iCommand) {
        logger.log(Level.INFO, "Error while action execution: " + iCommand.getClass().getSimpleName(), throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsSubmittedCommands() {
        Object object = this.commandListLock;
        synchronized (object) {
            return this.submittedCommands.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfActiveCommands() {
        Object object = this.commandListLock;
        synchronized (object) {
            return this.submittedCommands.size();
        }
    }

    static {
        logger = Logger.getLogger(CommandExecutionService.class.getName());
    }

    private class NotifyObserver
    implements GenericObserver<CommandExecutableTask.Executable> {
        private NotifyObserver() {
        }

        public void updatePerformed(CommandExecutableTask.Executable executable) {
            CommandExecutionService.this.commandExecutionObservable.fireObserverUpdate(new CommandExecutionEvent(executable.isErrorOccured() ? CommandExecutionEvent.CommandExecutionEventType.FAILED : CommandExecutionEvent.CommandExecutionEventType.COMPLETED, executable));
        }
    }

    private class CommandObserver
    implements GenericObserver<CommandExecutableTask.Executable> {
        private CommandObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updatePerformed(CommandExecutableTask.Executable executable) {
            Object object = CommandExecutionService.this.commandListLock;
            synchronized (object) {
                CommandExecutionService.this.submittedCommands.remove(executable.getCommand());
            }
        }
    }

    private class CommandExecutionObservable
    extends GenericObservable<CommandExecutionEvent> {
        private CommandExecutionObservable() {
        }

        public synchronized void fireObserverUpdate(CommandExecutionEvent commandExecutionEvent) {
            this.setChanged();
            this.notifyObservers(commandExecutionEvent);
        }
    }
}

