/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command.impl.app;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.exception.ExceptionCode;
import net.sf.amemailchecker.app.model.Settings;
import net.sf.amemailchecker.command.ICommand;
import net.sf.amemailchecker.command.exception.CommandExecutionException;
import net.sf.amemailchecker.command.impl.BaseStatusCommand;

public class ExportSettingsCommand
extends BaseStatusCommand<Void>
implements ICommand<Void> {
    private static final Logger logger = Logger.getLogger(ExportSettingsCommand.class.getName());
    private File file;

    public ExportSettingsCommand(File file) {
        this.file = file;
    }

    @Override
    public Void execute() throws CommandExecutionException {
        try {
            File file = new File(this.file, "AmeMailCheckerSettings-" + System.currentTimeMillis() + ".zip");
            int n = 2048;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
            zipOutputStream.setLevel(0);
            byte[] byArray = new byte[n];
            String[] stringArray = new String[3];
            Settings settings = ApplicationContext.getInstance().getSettings();
            stringArray[0] = settings.getUserDataFilePath();
            stringArray[1] = settings.getUserKeyFilePath();
            stringArray[2] = settings.getUserPreferencesFilePath();
            for (int i = 0; i < stringArray.length; ++i) {
                int n2;
                File file2 = new File(stringArray[i]);
                FileInputStream fileInputStream = new FileInputStream(file2);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, n);
                ZipEntry zipEntry = new ZipEntry(file2.getName());
                zipOutputStream.putNextEntry(zipEntry);
                while ((n2 = bufferedInputStream.read(byArray, 0, n)) != -1) {
                    zipOutputStream.write(byArray, 0, n2);
                }
                bufferedInputStream.close();
            }
            zipOutputStream.close();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
            throw new CommandExecutionException(ExceptionCode.UNABLE_SAVE_FILE, exception.getMessage(), exception);
        }
        return null;
    }
}

