/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command.impl.app;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.exception.ExceptionCode;
import net.sf.amemailchecker.command.ICommand;
import net.sf.amemailchecker.command.exception.CommandExecutionException;
import net.sf.amemailchecker.command.impl.BaseStatusCommand;

public class ImportSettingsCommand
extends BaseStatusCommand<Void>
implements ICommand<Void> {
    private static final Logger logger = Logger.getLogger(ImportSettingsCommand.class.getName());
    private File file;

    public ImportSettingsCommand(File file) {
        this.file = file;
    }

    @Override
    public Void execute() throws CommandExecutionException {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        int n = 1024;
        try {
            ZipFile zipFile = new ZipFile(this.file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                int n2;
                ZipEntry zipEntry = enumeration.nextElement();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                byte[] byArray = new byte[n];
                File file = new File(new File(applicationContext.getSettings().getUserDataDirPath()), zipEntry.getName());
                if (file.exists()) {
                    file.delete();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, n);
                while ((n2 = bufferedInputStream.read(byArray, 0, n)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n2);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                bufferedInputStream.close();
            }
            applicationContext.loadUserPreferences();
            applicationContext.loadUserData();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
            throw new CommandExecutionException(ExceptionCode.UNABLE_IMPORT_APP_SETTINGS, exception.getMessage(), exception);
        }
        return null;
    }
}

