/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command.impl.app;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import net.sf.amemailchecker.app.exception.ExceptionCode;
import net.sf.amemailchecker.command.ICommand;
import net.sf.amemailchecker.command.exception.CommandExecutionException;
import net.sf.amemailchecker.command.impl.BaseStatusCommand;
import net.sf.amemailchecker.command.impl.app.SaveSettingsCommand;
import net.sf.amemailchecker.mail.model.Attachment;

public class SaveAttachmentCommand
extends BaseStatusCommand<Void>
implements ICommand<Void> {
    private static final Logger logger = Logger.getLogger(SaveSettingsCommand.class.getName());
    private File file;
    private Attachment attachment;

    public SaveAttachmentCommand(Attachment attachment, File file) {
        this.file = file;
        this.attachment = attachment;
    }

    @Override
    public Void execute() throws CommandExecutionException {
        OutputStream outputStream = null;
        InputStream inputStream = null;
        if (this.file.isDirectory()) {
            this.file = new File(this.file.getPath() + File.separator + this.attachment.getName());
        }
        try {
            int n;
            Object[] objectArray;
            Object object;
            if (this.file.exists()) {
                String[] stringArray;
                object = this.file.getName();
                int n2 = ((String)object).lastIndexOf(46);
                if (n2 != -1) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = ((String)object).substring(0, n2);
                    stringArray = stringArray2;
                    stringArray2[1] = ((String)object).substring(n2 + 1, ((String)object).length());
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = object;
                }
                objectArray = stringArray;
                n = 0;
                while (this.file.exists()) {
                    object = objectArray[0] + "_[" + ++n + "]";
                    if (n2 != -1) {
                        object = (String)object + "." + objectArray[1];
                    }
                    this.file = new File(this.file.getParentFile().getCanonicalPath() + File.separator + (String)object);
                }
            }
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            object = this.attachment.getData();
            File file = this.attachment.getFile();
            if (object == null && file == null) {
                logger.info("Unable to save attachment because binary data & linked file are both NULL [" + this.attachment.getName() + "]");
                objectArray = null;
                return objectArray;
            }
            outputStream = new FileOutputStream(this.file);
            inputStream = object != null ? new ByteArrayInputStream((byte[])object) : new FileInputStream(file);
            objectArray = new byte[256];
            while (inputStream.read((byte[])objectArray) != -1) {
                ((FileOutputStream)outputStream).write((byte[])objectArray);
                if (objectArray.length < 256) {
                    break;
                }
                n = inputStream.available();
                if (n >= objectArray.length) continue;
                objectArray = new byte[n];
            }
        }
        catch (Exception exception) {
            throw new CommandExecutionException(ExceptionCode.UNABLE_SAVE_FILE, exception.getMessage(), exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }
}

