/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command.impl.app;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sf.amemailchecker.command.CommandExecutionService;
import net.sf.amemailchecker.command.ICommand;
import net.sf.amemailchecker.command.exception.CommandExecutionException;
import net.sf.amemailchecker.command.impl.BaseStatusCommand;
import net.sf.amemailchecker.command.impl.app.SaveAttachmentCommand;
import net.sf.amemailchecker.command.task.DefaultCommandExecutableTask;
import net.sf.amemailchecker.mail.model.Attachment;

public class SaveAttachmentMultipleCommand
extends BaseStatusCommand<Void>
implements ICommand<Void> {
    private File baseDir;
    private List<Attachment> attachments;

    public SaveAttachmentMultipleCommand(File file, List<Attachment> list) {
        this.baseDir = file;
        this.attachments = list;
    }

    @Override
    public Void execute() throws CommandExecutionException {
        CommandExecutionService commandExecutionService = CommandExecutionService.Service;
        for (Attachment attachment : this.attachments) {
            File file;
            try {
                file = new File(this.baseDir.getCanonicalPath() + File.separator + attachment.getName());
            }
            catch (IOException iOException) {
                file = new File(this.baseDir.getPath() + File.separator + attachment.getName());
            }
            SaveAttachmentCommand saveAttachmentCommand = new SaveAttachmentCommand(attachment, file);
            commandExecutionService.executeNotify(new DefaultCommandExecutableTask(saveAttachmentCommand));
        }
        return null;
    }
}

