/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command.impl.app;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.extension.ExtensionInfo;
import net.sf.amemailchecker.app.extension.ExtensionProvider;
import net.sf.amemailchecker.app.extension.ExtensionSettings;
import net.sf.amemailchecker.app.model.UserPreferences;
import net.sf.amemailchecker.app.notification.NotificationCache;
import net.sf.amemailchecker.app.notification.NotificationCacheEvent;
import net.sf.amemailchecker.command.ICommand;
import net.sf.amemailchecker.command.exception.CommandExecutionException;
import net.sf.amemailchecker.command.impl.BaseStatusCommand;
import net.sf.amemailchecker.command.timer.TimerWrapper;
import net.sf.amemailchecker.mail.model.Account;

public class SaveSettingsCommand
extends BaseStatusCommand<Void>
implements ICommand<Void> {
    private static final Logger logger = Logger.getLogger(SaveSettingsCommand.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void execute() throws CommandExecutionException {
        Class<SaveSettingsCommand> clazz = SaveSettingsCommand.class;
        synchronized (SaveSettingsCommand.class) {
            try {
                NotificationCache notificationCache = NotificationCache.getInstance();
                ApplicationContext applicationContext = ApplicationContext.getInstance();
                UserPreferences userPreferences = applicationContext.getUserData().getPreferences();
                Collection<Account> collection = applicationContext.getUserData().getAccounts();
                for (Account object : collection) {
                    if (!userPreferences.isEmptyCacheAccountInactive() || object.isActive()) continue;
                    notificationCache.remove(object.getUuid());
                    notificationCache.fireObserverUpdate(new NotificationCacheEvent(NotificationCacheEvent.NotificationCacheEventType.REMOVED, object));
                }
                applicationContext.storeUserData();
                for (ExtensionInfo extensionInfo : ExtensionProvider.Provider.getExtensions()) {
                    ExtensionSettings extensionSettings = extensionInfo.getExtension().settings();
                    if (extensionSettings == null) continue;
                    try {
                        extensionSettings.save();
                    }
                    catch (Exception exception) {
                        logger.log(Level.SEVERE, "Unable to save extension configuration for extension [" + extensionInfo.getName() + "]", exception);
                    }
                }
                TimerWrapper timerWrapper = (TimerWrapper)ApplicationContext.getInstance().getObject(TimerWrapper.class.getName());
                timerWrapper.restartTimer(applicationContext.getUserData().getPreferences().getMinCheckInterval());
            }
            catch (Exception exception) {
                throw new CommandExecutionException(exception.getMessage());
            }
            return null;
        }
    }
}

