/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command.impl.app;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.command.ICommand;
import net.sf.amemailchecker.command.exception.CommandExecutionException;
import net.sf.amemailchecker.command.exception.MailCommandExecutionException;
import net.sf.amemailchecker.command.impl.BaseStatusCommand;
import net.sf.amemailchecker.command.impl.mail.LoadFoldersListCommand;
import net.sf.amemailchecker.gui.messageviewer.foldertree.FolderTreeModelHierarchyIterator;
import net.sf.amemailchecker.mail.impl.mailbox.FolderImpl;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.MailBox;

public class SynchronizeFolderListCommand
extends BaseStatusCommand<Void>
implements ICommand<Void> {
    private static final Logger logger = Logger.getLogger(SynchronizeFolderListCommand.class.getName());

    @Override
    public Void execute() throws CommandExecutionException {
        for (Account account : ApplicationContext.getInstance().getAccountsCache().getAccounts()) {
            List list;
            if (!account.getMailBoxPreferences().isSynchronizeFoldersAtStartup()) continue;
            try {
                list = (List)new LoadFoldersListCommand(account, null).execute();
            }
            catch (MailCommandExecutionException mailCommandExecutionException) {
                logger.log(Level.INFO, "Unable to refresh folder list for " + account.getTitle());
                logger.log(Level.SEVERE, mailCommandExecutionException.getMessage(), mailCommandExecutionException);
                continue;
            }
            MailBox mailBox = account.getMailBox();
            FolderTreeModelHierarchyIterator folderTreeModelHierarchyIterator = new FolderTreeModelHierarchyIterator(list);
            FolderTreeModelHierarchyIterator folderTreeModelHierarchyIterator2 = new FolderTreeModelHierarchyIterator(mailBox.getFolders());
            while (folderTreeModelHierarchyIterator.hasNext()) {
                Folder folder = (Folder)folderTreeModelHierarchyIterator.next();
                boolean bl = false;
                while (folderTreeModelHierarchyIterator2.hasNext()) {
                    Folder folder2 = (Folder)folderTreeModelHierarchyIterator2.next();
                    if (!folder2.equals(folder)) continue;
                    bl = folder2.isEnabled();
                    break;
                }
                folderTreeModelHierarchyIterator2.reset();
                ((FolderImpl)folder).setEnabled(bl);
            }
            mailBox.getFolders().clear();
            mailBox.getFolders().addAll(list);
        }
        return null;
    }
}

