/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command.impl.mail;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.app.exception.ExceptionCode;
import net.sf.amemailchecker.command.exception.MailCommandExecutionException;
import net.sf.amemailchecker.command.impl.BaseStatusCommand;
import net.sf.amemailchecker.command.impl.mail.MailServiceCommand;
import net.sf.amemailchecker.mail.IMailClient;
import net.sf.amemailchecker.mail.exception.AuthenticationException;
import net.sf.amemailchecker.mail.exception.FolderNotFoundException;
import net.sf.amemailchecker.mail.exception.MessageNotFoundException;
import net.sf.amemailchecker.mail.exception.ProtocolException;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.proxy.exception.ProxyNegotiationException;

abstract class BaseMailServiceCommand<IP, OP>
extends BaseStatusCommand
implements MailServiceCommand<IP, OP> {
    protected static final Logger logger = Logger.getLogger(MailServiceCommand.class.getName());
    Account account;
    Folder folder;
    IP input;
    IMailClient client;

    public BaseMailServiceCommand() {
    }

    public BaseMailServiceCommand(Account account, IP IP) {
        this.account = account;
        this.input = IP;
    }

    public BaseMailServiceCommand(Account account, Folder folder, IP IP) {
        this(account, IP);
        this.folder = folder;
    }

    @Override
    public OP execute() throws MailCommandExecutionException {
        try {
            OP OP = this.executeCommand(this.account, this.input);
            return OP;
        }
        catch (ProxyNegotiationException proxyNegotiationException) {
            throw new MailCommandExecutionException(proxyNegotiationException.getCode(), proxyNegotiationException.getMessage());
        }
        catch (AuthenticationException authenticationException) {
            throw new MailCommandExecutionException(ExceptionCode.AUTH_FAILED, authenticationException.getMessage());
        }
        catch (MessageNotFoundException messageNotFoundException) {
            throw new MailCommandExecutionException(ExceptionCode.MESSAGE_NOT_FOUND, messageNotFoundException.getMessage());
        }
        catch (FolderNotFoundException folderNotFoundException) {
            throw new MailCommandExecutionException(ExceptionCode.FOLDER_NOT_FOUND, folderNotFoundException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MailCommandExecutionException(ExceptionCode.ERROR_EXEC_PROTOCOL_COMMAND, protocolException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            throw new MailCommandExecutionException(ExceptionCode.UNKNOWN_HOSTNAME, unknownHostException.getMessage());
        }
        catch (IOException iOException) {
            throw new MailCommandExecutionException(ExceptionCode.ERROR_NET_IO, iOException.getMessage());
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
            throw new MailCommandExecutionException(ExceptionCode.INTERNAL_ERROR, exception.getMessage(), exception);
        }
        finally {
            this.cancel();
        }
    }

    @Override
    public OP execute(Account account, IP IP) throws MailCommandExecutionException {
        this.account = account;
        this.input = IP;
        return this.execute();
    }

    protected abstract OP executeCommand(Account var1, IP var2) throws IOException, ProtocolException;

    @Override
    public void cancel() {
        if (this.client != null && this.client.isConnected()) {
            this.client.disconnect();
        }
    }
}

