/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command.impl.mail;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.sf.amemailchecker.app.notification.NotificationCache;
import net.sf.amemailchecker.app.notification.NotificationCacheEvent;
import net.sf.amemailchecker.command.impl.mail.BaseMailServiceCommand;
import net.sf.amemailchecker.mail.IMailIngoingClient;
import net.sf.amemailchecker.mail.exception.ProtocolException;
import net.sf.amemailchecker.mail.factory.MailClientFactory;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.Letter;

abstract class BaseMarkMessageCommand
extends BaseMailServiceCommand<Letter[], Void> {
    public BaseMarkMessageCommand(Folder folder) {
        this.folder = folder;
    }

    public BaseMarkMessageCommand(Account account, Folder folder, Letter ... letterArray) {
        super(account, folder, letterArray);
    }

    @Override
    public Void executeCommand(Account account, Letter ... letterArray) throws IOException, ProtocolException {
        this.client = MailClientFactory.getInstance().getIngoingClient(account);
        List<String> list = this.doMark((IMailIngoingClient)this.client, Arrays.asList(letterArray));
        ArrayList<Letter> arrayList = new ArrayList<Letter>();
        for (Letter letter : letterArray) {
            for (String string : list) {
                if (!letter.getUid().equalsIgnoreCase(string)) continue;
                arrayList.add(letter);
                NotificationCache.getInstance().get(account.getUuid(), this.folder).remove(letter);
            }
        }
        if (list.size() != letterArray.length) {
            this.status = "The " + (letterArray.length - list.size()) + " messages were not marked";
        }
        HashMap hashMap = new HashMap();
        hashMap.put(this.folder, arrayList);
        NotificationCache.getInstance().fireObserverUpdate(new NotificationCacheEvent(NotificationCacheEvent.NotificationCacheEventType.MARKED, account, hashMap));
        return null;
    }

    protected abstract List<String> doMark(IMailIngoingClient var1, List<Letter> var2) throws IOException, ProtocolException;
}

