/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command.impl.mail;

import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.notification.NotificationCache;
import net.sf.amemailchecker.app.notification.NotificationCacheEvent;
import net.sf.amemailchecker.command.ICommand;
import net.sf.amemailchecker.command.exception.MailCommandExecutionException;
import net.sf.amemailchecker.command.impl.BaseStatusCommand;
import net.sf.amemailchecker.command.impl.app.ShowMailNotificationCommand;
import net.sf.amemailchecker.command.impl.mail.CheckUnreadSingleCommand;
import net.sf.amemailchecker.mail.model.Account;

public class CheckUnreadMultipleCommand
extends BaseStatusCommand<Void>
implements ICommand<Void> {
    private static final Logger logger = Logger.getLogger(CheckUnreadMultipleCommand.class.getName());
    private volatile int semaphoreIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void execute() {
        Class<CheckUnreadMultipleCommand> clazz = CheckUnreadMultipleCommand.class;
        synchronized (CheckUnreadMultipleCommand.class) {
            final ApplicationContext applicationContext = ApplicationContext.getInstance();
            Collection<Account> collection = applicationContext.getAccountsCache().getAccounts();
            if (!applicationContext.getAccountsCache().hasActive()) {
                logger.info("No active accounts have been found! Mail checking is aborted.");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            applicationContext.getStateContext().mailCheckingStarted();
            NotificationCache.getInstance().clearErrors();
            int n = 0;
            for (final Account account : collection) {
                if (!account.isActive()) continue;
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            Map map = (Map)new CheckUnreadSingleCommand().execute(account, account.getMailBox());
                            NotificationCache.getInstance().put(account.getUuid(), map);
                            NotificationCache.getInstance().fireObserverUpdate(new NotificationCacheEvent(NotificationCacheEvent.NotificationCacheEventType.NEW, account, map));
                        }
                        catch (MailCommandExecutionException mailCommandExecutionException) {
                            logger.info("An error occurred in mail checking activity for account [" + account.getTitle() + "]");
                            logger.log(Level.INFO, applicationContext.getExceptionCodesBundle().get(mailCommandExecutionException.getExceptionCode().getIdString()));
                            NotificationCache.getInstance().error(account.getUuid(), ApplicationContext.getInstance().getExceptionCodesBundle().get(mailCommandExecutionException.getExceptionCode().getIdString()) + "\n" + mailCommandExecutionException.getMessage());
                        }
                        CheckUnreadMultipleCommand.this.semaphoreIndex++;
                    }
                };
                ++n;
                thread.start();
            }
            while (this.semaphoreIndex != n) {
            }
            applicationContext.getStateContext().mailCheckingFinished();
            new ShowMailNotificationCommand(false).execute();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }
}

