/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command.impl.mail;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.sf.amemailchecker.app.notification.NotificationCache;
import net.sf.amemailchecker.command.impl.mail.BaseMailServiceCommand;
import net.sf.amemailchecker.mail.IMailIngoingClient;
import net.sf.amemailchecker.mail.cache.PostalAddresseeCache;
import net.sf.amemailchecker.mail.exception.ProtocolException;
import net.sf.amemailchecker.mail.factory.MailClientFactory;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.Letter;
import net.sf.amemailchecker.mail.model.MailBox;

public class CheckUnreadSingleCommand
extends BaseMailServiceCommand<MailBox, Map<Folder, List<Letter>>> {
    @Override
    public Map<Folder, List<Letter>> executeCommand(Account account, MailBox mailBox) throws IOException, ProtocolException {
        this.client = MailClientFactory.getInstance().getIngoingClient(account);
        ((IMailIngoingClient)this.client).setCheckedUidList(NotificationCache.getInstance().getUidList(account.getUuid()));
        Map<Folder, List<Letter>> map = ((IMailIngoingClient)this.client).checkUnread(mailBox, account.getMailBoxPreferences().isDownloadCompleteLetter());
        NotificationCache.getInstance().remove(account.getUuid(), ((IMailIngoingClient)this.client).getCheckedUidList());
        for (List<Letter> list : map.values()) {
            this.updateRecipients(list);
        }
        return map;
    }

    private void updateRecipients(List<Letter> list) {
        for (Letter letter : list) {
            LetterImpl letterImpl = (LetterImpl)letter;
            PostalAddresseeCache.Instance.fill(letterImpl.getSender());
            if (letterImpl.hasRecipients("To")) {
                PostalAddresseeCache.Instance.fill(letterImpl.getRecipients("To"));
            }
            if (!letterImpl.hasRecipients("CC")) continue;
            PostalAddresseeCache.Instance.fill(letterImpl.getRecipients("CC"));
        }
    }
}

