/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command.impl.mail;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import net.sf.amemailchecker.app.notification.NotificationCache;
import net.sf.amemailchecker.command.impl.mail.BaseMailServiceCommand;
import net.sf.amemailchecker.mail.IMailIngoingClient;
import net.sf.amemailchecker.mail.exception.ProtocolException;
import net.sf.amemailchecker.mail.factory.MailClientFactory;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.Letter;

public class CopyLettersCommand
extends BaseMailServiceCommand<List<Letter>, Void> {
    private Folder to;

    public CopyLettersCommand(Account account, Folder folder, Folder folder2, List<Letter> list) {
        super(account, folder, list);
        this.to = folder2;
    }

    @Override
    protected Void executeCommand(Account account, List<Letter> list) throws IOException, ProtocolException {
        this.client = MailClientFactory.getInstance().getIngoingClient(account);
        List<Letter> list2 = ((IMailIngoingClient)this.client).copy(list, this.folder, this.to);
        if (this.to.isEnabled()) {
            HashMap<Folder, List<Letter>> hashMap = new HashMap<Folder, List<Letter>>();
            hashMap.put(this.to, list2);
            NotificationCache.getInstance().put(account.getUuid(), hashMap);
        }
        return null;
    }
}

