/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command.impl.mail;

import java.io.IOException;
import java.util.logging.Level;
import net.sf.amemailchecker.command.impl.mail.BaseMailServiceCommand;
import net.sf.amemailchecker.mail.IMailIngoingClient;
import net.sf.amemailchecker.mail.exception.ProtocolException;
import net.sf.amemailchecker.mail.factory.MailClientFactory;
import net.sf.amemailchecker.mail.impl.mailbox.FolderAttribute;
import net.sf.amemailchecker.mail.impl.mailbox.IMAPFolder;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;

public class CreateFolderCommand
extends BaseMailServiceCommand<String, Folder> {
    private Folder parent;

    public CreateFolderCommand(Account account, String string, Folder folder) {
        super(account, string);
        this.parent = folder;
    }

    @Override
    protected Folder executeCommand(Account account, String string) throws IOException, ProtocolException {
        this.client = MailClientFactory.getInstance().getIngoingClient(account);
        String string2 = this.parent != null ? this.parent.getDelimiter() : "/";
        String string3 = this.parent != null ? this.parent.getName() : string2;
        IMAPFolder iMAPFolder = new IMAPFolder();
        iMAPFolder.addAttribute(FolderAttribute.HasNoChildren.name());
        iMAPFolder.setDelimiter(string2);
        iMAPFolder.setLabel(string);
        iMAPFolder.setEnabled(true);
        ((IMailIngoingClient)this.client).createFolder(iMAPFolder, this.parent, string);
        if (this.parent != null) {
            this.parent.getChildren().add(iMAPFolder);
        } else {
            account.getMailBox().getFolders().add(iMAPFolder);
        }
        logger.log(Level.INFO, "Folder with name [" + string + "] has been successfully created under [" + string3 + "]");
        return iMAPFolder;
    }
}

