/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command.impl.mail;

import java.io.IOException;
import java.util.logging.Level;
import net.sf.amemailchecker.app.notification.NotificationCache;
import net.sf.amemailchecker.command.impl.mail.BaseMailServiceCommand;
import net.sf.amemailchecker.mail.IMailIngoingClient;
import net.sf.amemailchecker.mail.exception.ProtocolException;
import net.sf.amemailchecker.mail.factory.MailClientFactory;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;

public class DeleteFolderCommand
extends BaseMailServiceCommand<Folder, Folder> {
    public DeleteFolderCommand(Account account, Folder folder, Folder folder2) {
        super(account, folder2, folder);
    }

    @Override
    protected Folder executeCommand(Account account, Folder folder) throws IOException, ProtocolException {
        this.client = MailClientFactory.getInstance().getIngoingClient(account);
        ((IMailIngoingClient)this.client).deleteFolder(folder);
        if (this.folder != null) {
            this.folder.getChildren().remove(folder);
        } else {
            account.getMailBox().getFolders().remove(folder);
        }
        NotificationCache.getInstance().remove(account.getUuid(), folder);
        logger.log(Level.INFO, "Folder with name [" + folder.getName() + "] has been successfully deleted");
        return folder;
    }
}

