/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command.impl.mail;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.amemailchecker.command.impl.mail.BaseMailServiceCommand;
import net.sf.amemailchecker.mail.IMailIngoingClient;
import net.sf.amemailchecker.mail.MessageFlag;
import net.sf.amemailchecker.mail.exception.ProtocolException;
import net.sf.amemailchecker.mail.factory.MailClientFactory;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.Letter;

public class FetchMessageCommand
extends BaseMailServiceCommand<Letter[], List<Letter>> {
    public FetchMessageCommand(Account account, Folder folder, Letter ... letterArray) {
        super(account, folder, letterArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Letter> executeCommand(Account account, Letter ... letterArray) throws IOException, ProtocolException {
        List<Letter> list = new ArrayList<Letter>();
        for (Letter letter : letterArray) {
            Letter letter2 = ((LetterImpl)letter).getFlags();
            if (letter2.contains((Object)MessageFlag.Fetched) || letter2.contains((Object)MessageFlag.Fetching)) continue;
            ((LetterImpl)letter).addFlag(MessageFlag.Fetching);
            list.add(letter);
        }
        this.input = list.toArray(new Letter[list.size()]);
        this.client = MailClientFactory.getInstance().getIngoingClient(account);
        Class<FetchMessageCommand> clazz = FetchMessageCommand.class;
        synchronized (FetchMessageCommand.class) {
            list = ((IMailIngoingClient)this.client).fetch(this.folder, list);
            for (Letter letter2 : (Letter[])this.input) {
                ((LetterImpl)letter2).addFlag(MessageFlag.Fetched);
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return list;
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        for (Letter letter : (Letter[])this.input) {
            ((LetterImpl)letter).getFlags().remove((Object)MessageFlag.Fetching);
        }
    }
}

