/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command.task;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import net.sf.amemailchecker.command.CommandErrorHandler;
import net.sf.amemailchecker.command.CommandExecutionListener;
import net.sf.amemailchecker.command.ICommand;
import net.sf.amemailchecker.command.exception.CommandExecutionException;
import net.sf.amemailchecker.command.task.CommandExecutable;
import net.sf.amemailchecker.command.task.ExecutableTask;
import net.sf.amemailchecker.util.GenericObservable;
import net.sf.amemailchecker.util.GenericObserver;

public abstract class CommandExecutableTask
implements ExecutableTask {
    Executable executable;
    List<CommandErrorHandler> errorHandlers = new ArrayList<CommandErrorHandler>();
    private EventListenerList commandListeners;
    protected static final Logger logger = Logger.getLogger(CommandExecutableTask.class.getName());

    protected CommandExecutableTask(ICommand iCommand) {
        this.executable = new Executable(iCommand);
        this.commandListeners = new EventListenerList();
    }

    @Override
    public void addCommandExecutionListener(CommandExecutionListener commandExecutionListener) {
        this.commandListeners.add(CommandExecutionListener.class, commandExecutionListener);
    }

    public CommandExecutionListener[] getCommandExecutionListeners() {
        return (CommandExecutionListener[])this.commandListeners.getListeners(CommandExecutionListener.class);
    }

    @Override
    public void run() {
        for (CommandExecutionListener commandExecutionListener : this.getCommandExecutionListeners()) {
            commandExecutionListener.beforeExecution(this.executable);
        }
        this.executable = this.doTask();
        for (CommandExecutionListener commandExecutionListener : this.getCommandExecutionListeners()) {
            commandExecutionListener.afterExecution(this.executable);
        }
        this.executeUpdate(this.executable);
    }

    abstract Executable doTask();

    abstract void executeUpdate(Executable var1);

    @Override
    public CommandExecutable getExecutable() {
        return this.executable;
    }

    @Override
    public ICommand getCommand() {
        return this.executable.getCommand();
    }

    @Override
    public void addExecutableObserver(GenericObserver genericObserver) {
        this.executable.addObserver(genericObserver);
    }

    @Override
    public void addCommandErrorHandler(CommandErrorHandler commandErrorHandler) {
        this.errorHandlers.add(commandErrorHandler);
    }

    protected void notifyErrorHandlers(Executable executable) {
        CommandExecutionException commandExecutionException = executable.getException();
        this.logError(commandExecutionException, executable.getCommand());
        for (CommandErrorHandler commandErrorHandler : this.errorHandlers) {
            commandErrorHandler.handle(commandExecutionException);
        }
    }

    protected void logError(Throwable throwable, ICommand iCommand) {
        logger.log(Level.INFO, "Error while action execution: " + iCommand.getClass().getSimpleName(), throwable);
    }

    public class Executable
    extends GenericObservable
    implements Runnable,
    CommandExecutable {
        private ICommand command;
        private CommandExecutionException exception;
        private boolean isExecutionPerformed;
        private Object executionResult;

        Executable(ICommand iCommand) {
            this.command = iCommand;
        }

        @Override
        public void run() {
            try {
                this.executionResult = this.command.execute();
            }
            catch (CommandExecutionException commandExecutionException) {
                this.exception = commandExecutionException;
            }
        }

        public void notifyObservers() {
            this.setChanged();
            super.notifyObservers((Object)this);
        }

        @Override
        public CommandExecutionException getException() {
            return this.exception;
        }

        @Override
        public boolean isErrorOccured() {
            return this.exception != null;
        }

        @Override
        public ICommand getCommand() {
            return this.command;
        }

        @Override
        public boolean isExecutionPerformed() {
            return this.isExecutionPerformed;
        }

        public void setExecutionPerformed(boolean bl) {
            this.isExecutionPerformed = bl;
        }

        public Object getExecutionResult() {
            return this.executionResult;
        }
    }
}

