/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command.task;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.sf.amemailchecker.command.ICommand;
import net.sf.amemailchecker.command.task.CommandExecutableTask;

public class DefaultCommandExecutableTask
extends CommandExecutableTask {
    protected Future future;

    public DefaultCommandExecutableTask(ICommand iCommand) {
        super(iCommand);
    }

    @Override
    CommandExecutableTask.Executable doTask() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        this.future = executorService.submit(this.executable);
        try {
            this.future.get();
        }
        catch (InterruptedException interruptedException) {
            this.logError(interruptedException, this.executable.getCommand());
        }
        catch (ExecutionException executionException) {
            this.logError(executionException, this.executable.getCommand());
        }
        catch (CancellationException cancellationException) {
            logger.info("Current action - [" + this.executable.getCommand().getClass().getSimpleName() + "] - has been cancelled");
            this.executable.getCommand().cancel();
        }
        this.executable.setExecutionPerformed(!this.future.isCancelled());
        this.executable.notifyObservers();
        return this.executable;
    }

    @Override
    void executeUpdate(CommandExecutableTask.Executable executable) {
        if (!executable.isExecutionPerformed()) {
            return;
        }
        if (executable.isErrorOccured() && this.errorHandlers.size() > 0) {
            this.notifyErrorHandlers(executable);
        }
    }
}

