/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.command.task;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.command.CommandExecutionListener;
import net.sf.amemailchecker.command.ICommand;
import net.sf.amemailchecker.command.exception.CommandExecutionException;
import net.sf.amemailchecker.command.task.CommandExecutable;
import net.sf.amemailchecker.command.task.CommandExecutableTask;
import net.sf.amemailchecker.command.task.DefaultCommandExecutableTask;
import net.sf.amemailchecker.gui.notification.NotificationType;
import net.sf.amemailchecker.gui.notification.NotificationWindowFactory;
import net.sf.amemailchecker.gui.notification.window.modal.IModalNotificationWindow;
import net.sf.amemailchecker.gui.notification.window.modal.ProgressNotificationWindow;

public class NotificationBlockUITask
extends DefaultCommandExecutableTask {
    private IModalNotificationWindow window;
    private Window parent;

    public NotificationBlockUITask(ICommand iCommand, final Window window) {
        super(iCommand);
        this.parent = window;
        this.addCommandExecutionListener(new CommandExecutionListener(){

            public void beforeExecution(CommandExecutable commandExecutable) {
                if (commandExecutable.getCommand().isCancelableFacility()) {
                    NotificationBlockUITask.this.window = NotificationWindowFactory.getProgressNotificationWindow(window, true);
                    ((ProgressNotificationWindow)NotificationBlockUITask.this.window).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            NotificationBlockUITask.this.future.cancel(true);
                        }
                    });
                } else {
                    NotificationBlockUITask.this.window = NotificationWindowFactory.getProgressNotificationWindow(window);
                }
                NotificationBlockUITask.this.window.showNotificationOnGlass();
            }

            public void afterExecution(CommandExecutable commandExecutable) {
                NotificationBlockUITask.this.window.hideNotification();
            }
        });
    }

    @Override
    void executeUpdate(CommandExecutableTask.Executable executable) {
        super.executeUpdate(executable);
        String string = executable.getCommand().status();
        String string2 = null;
        NotificationType notificationType = NotificationType.INFO;
        CommandExecutionException commandExecutionException = executable.getException();
        if (commandExecutionException != null) {
            this.logError(commandExecutionException, executable.getCommand());
            string = ApplicationContext.getInstance().getExceptionCodesBundle().get(commandExecutionException.getExceptionCode().getIdString());
            string2 = commandExecutionException.getMessage();
            notificationType = NotificationType.ERROR;
        }
        if (!string.equals("")) {
            if (string2 != null && !string2.equals("")) {
                NotificationWindowFactory.getSystemNotificationExtendedInfoWindow(string, string2, this.parent).showNotification(notificationType);
            } else {
                NotificationWindowFactory.getSystemNotificationWindow(string, this.parent).showNotification(notificationType);
            }
        }
    }
}

