/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.db;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.db.common.DBDataSourceFactory;
import net.sf.amemailchecker.db.common.DBQueryResolver;
import net.sf.amemailchecker.db.common.DataBaseNegotiationException;
import net.sf.amemailchecker.db.common.annotation.Parameterized;
import net.sf.amemailchecker.db.common.annotation.Parameterizes;
import net.sf.amemailchecker.db.common.annotation.Selector;
import net.sf.amemailchecker.db.common.annotation.Selectors;
import net.sf.amemailchecker.db.common.annotation.TableDefinition;

public abstract class BaseJdbcDAO<ID> {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    protected DBQueryResolver queryResolver = new DBQueryResolver();
    protected DBDataSourceFactory dataSourceFactory = DBDataSourceFactory.getInstance();

    protected ResultSet executeSelect(Connection connection, String string, Object ... objectArray) throws DataBaseNegotiationException {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string, 1004, 1007);
            for (int i = 0; i < objectArray.length; ++i) {
                preparedStatement.setObject(i + 1, objectArray[i]);
            }
            this.logger.log(Level.INFO, string);
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw new DataBaseNegotiationException(exception);
        }
    }

    protected Object executeCustomSelect(String string, String string2, Object ... objectArray) throws DataBaseNegotiationException {
        Connection connection = null;
        try {
            connection = this.dataSourceFactory.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(string2, 1004, 1007);
            for (int i = 0; i < objectArray.length; ++i) {
                preparedStatement.setObject(i + 1, objectArray[i]);
            }
            this.logger.log(Level.INFO, string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            Method method = this.getClass().getDeclaredMethod(string, ResultSet.class);
            method.setAccessible(true);
            Object object = method.invoke((Object)this, resultSet);
            return object;
        }
        catch (Exception exception) {
            throw new DataBaseNegotiationException(exception);
        }
        finally {
            if (connection != null) {
                this.dataSourceFactory.releaseConnection(connection);
            }
        }
    }

    protected Object executeSelectQuery(String string, Object ... objectArray) throws DataBaseNegotiationException {
        String string2;
        Selector selector = this.getSelector(string);
        switch (selector.mode()) {
            case COUNT: {
                string2 = this.queryResolver.querySelectCount(this.getTableDefinition(), selector);
                break;
            }
            case PARTIALLY: {
                string2 = this.queryResolver.querySelectPartially(this.getTableDefinition(), selector);
                break;
            }
            default: {
                string2 = this.queryResolver.querySelect(this.getTableDefinition(), selector);
            }
        }
        Connection connection = null;
        try {
            connection = this.dataSourceFactory.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(string2, 1004, 1007);
            for (int i = 0; i < objectArray.length; ++i) {
                preparedStatement.setObject(i + 1, objectArray[i]);
            }
            this.logger.log(Level.INFO, string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            Method method = this.getClass().getDeclaredMethod(selector.resultSetRoutine(), ResultSet.class);
            method.setAccessible(true);
            Object object = method.invoke((Object)this, resultSet);
            return object;
        }
        catch (Exception exception) {
            throw new DataBaseNegotiationException(exception);
        }
        finally {
            if (connection != null) {
                this.dataSourceFactory.releaseConnection(connection);
            }
        }
    }

    protected ResultSet executeSelectQuery(Connection connection, String string, Object ... objectArray) throws Exception {
        String string2;
        Selector selector = this.getSelector(string);
        switch (selector.mode()) {
            case COUNT: {
                string2 = this.queryResolver.querySelectCount(this.getTableDefinition(), selector);
                break;
            }
            case PARTIALLY: {
                string2 = this.queryResolver.querySelectPartially(this.getTableDefinition(), selector);
                break;
            }
            default: {
                string2 = this.queryResolver.querySelect(this.getTableDefinition(), selector);
            }
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string2, 1004, 1007);
        for (int i = 0; i < objectArray.length; ++i) {
            preparedStatement.setObject(i + 1, objectArray[i]);
        }
        this.logger.log(Level.INFO, string2);
        return preparedStatement.executeQuery();
    }

    protected ID executeQueryInsert(Object ... objectArray) throws DataBaseNegotiationException {
        return this.executeInsert(this.queryResolver.queryInsert(this.getTableDefinition()), objectArray);
    }

    protected ID executeInsert(String string, Object ... objectArray) throws DataBaseNegotiationException {
        Connection connection = null;
        try {
            connection = this.dataSourceFactory.getConnection();
            this.logger.log(Level.INFO, string);
            PreparedStatement preparedStatement = connection.prepareStatement(string, 1);
            for (int i = 0; i < objectArray.length; ++i) {
                preparedStatement.setObject(i + 1, objectArray[i]);
            }
            preparedStatement.executeUpdate();
            ResultSet resultSet = preparedStatement.getGeneratedKeys();
            Object object = null;
            if (resultSet.isBeforeFirst()) {
                resultSet.next();
                object = resultSet.getObject(1);
            }
            resultSet.close();
            preparedStatement.close();
            Object object2 = object;
            return (ID)object2;
        }
        catch (Exception exception) {
            throw new DataBaseNegotiationException(exception);
        }
        finally {
            if (connection != null) {
                this.dataSourceFactory.releaseConnection(connection);
            }
        }
    }

    protected void executeQueryUpdate(String string, Object ... objectArray) throws DataBaseNegotiationException {
        String string2 = this.queryResolver.queryUpdate(this.getTableDefinition(), this.getParameterized(string));
        try {
            this.executeUpdate(string2, objectArray);
        }
        catch (Exception exception) {
            throw new DataBaseNegotiationException("Unable to perform update", exception);
        }
    }

    protected void executeQueryDelete(String string, Object ... objectArray) throws DataBaseNegotiationException {
        String string2 = this.queryResolver.queryDelete(this.getTableDefinition(), this.getParameterized(string));
        try {
            this.executeUpdate(string2, objectArray);
        }
        catch (Exception exception) {
            throw new DataBaseNegotiationException("Unable to perform deletion", exception);
        }
    }

    protected void executeUpdate(String string, Object ... objectArray) throws DataBaseNegotiationException {
        Connection connection = null;
        try {
            connection = this.dataSourceFactory.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            for (int i = 0; i < objectArray.length; ++i) {
                preparedStatement.setObject(i + 1, objectArray[i]);
            }
            this.logger.log(Level.INFO, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (Exception exception) {
            throw new DataBaseNegotiationException(exception);
        }
        finally {
            this.dataSourceFactory.releaseConnection(connection);
        }
    }

    public TableDefinition getTableDefinition() {
        for (Annotation annotation : this.getClass().getAnnotations()) {
            if (!(annotation instanceof TableDefinition)) continue;
            return (TableDefinition)annotation;
        }
        return null;
    }

    public Selector getSelector(String string) {
        Selectors selectors = this.getClass().getAnnotation(Selectors.class);
        if (selectors != null) {
            for (Annotation annotation : selectors.selectors()) {
                if (!annotation.name().equals(string)) continue;
                return annotation;
            }
        }
        for (Annotation annotation : this.getClass().getAnnotations()) {
            if (!(annotation instanceof Selector)) continue;
            return (Selector)annotation;
        }
        return null;
    }

    public Parameterized getParameterized(String string) {
        Parameterizes parameterizes = this.getClass().getAnnotation(Parameterizes.class);
        if (parameterizes != null) {
            for (Annotation annotation : parameterizes.parameterizes()) {
                if (!annotation.name().equals(string)) continue;
                return annotation;
            }
        }
        for (Annotation annotation : this.getClass().getAnnotations()) {
            if (!(annotation instanceof Parameterized) || !((Parameterized)annotation).name().equals(string)) continue;
            return (Parameterized)annotation;
        }
        return null;
    }
}

