/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import net.sf.amemailchecker.db.BaseJdbcDAO;
import net.sf.amemailchecker.db.common.DataBaseNegotiationException;

public abstract class BaseJdbcObjectAwareDAO<T, ID>
extends BaseJdbcDAO<ID> {
    protected List<T> processResultSetList(ResultSet resultSet) throws Exception {
        ArrayList<T> arrayList = new ArrayList<T>();
        if (resultSet.isBeforeFirst()) {
            while (resultSet.next()) {
                arrayList.add(this.processResultSetForObject(resultSet));
            }
        }
        return arrayList;
    }

    protected T getSelectionOne(String string, Object ... objectArray) throws DataBaseNegotiationException {
        List<T> list = this.getSelectionList(string, objectArray);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    protected T selectionOne(String string, Object ... objectArray) throws DataBaseNegotiationException {
        List<T> list = this.selectionList(string, objectArray);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    protected List<T> getSelectionList(String string, Object ... objectArray) throws DataBaseNegotiationException {
        Connection connection = null;
        try {
            connection = this.dataSourceFactory.getConnection();
            ResultSet resultSet = this.executeSelectQuery(connection, string, objectArray);
            List<T> list = this.processResultSetList(resultSet);
            resultSet.close();
            List<T> list2 = list;
            return list2;
        }
        catch (Exception exception) {
            throw new DataBaseNegotiationException(exception);
        }
        finally {
            if (connection != null) {
                this.dataSourceFactory.releaseConnection(connection);
            }
        }
    }

    protected List<T> selectionList(String string, Object ... objectArray) throws DataBaseNegotiationException {
        Connection connection = null;
        try {
            connection = this.dataSourceFactory.getConnection();
            ResultSet resultSet = this.executeSelect(connection, string, objectArray);
            List<T> list = this.processResultSetList(resultSet);
            resultSet.close();
            List<T> list2 = list;
            return list2;
        }
        catch (Exception exception) {
            throw new DataBaseNegotiationException(exception);
        }
        finally {
            if (connection != null) {
                this.dataSourceFactory.releaseConnection(connection);
            }
        }
    }

    protected abstract T processResultSetForObject(ResultSet var1) throws Exception;
}

