/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.db;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.app.account.AccountCacheEvent;
import net.sf.amemailchecker.db.DefaultDAOFactory;
import net.sf.amemailchecker.db.common.DataBaseNegotiationException;
import net.sf.amemailchecker.db.dao.POP3MarkedCacheDAO;
import net.sf.amemailchecker.mail.Protocol;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.util.GenericObserver;

public class DataBaseObserver
implements GenericObserver<AccountCacheEvent> {
    private static final Logger logger = Logger.getLogger(DataBaseObserver.class.getSimpleName());

    public void updatePerformed(AccountCacheEvent accountCacheEvent) {
        if (!accountCacheEvent.getType().equals((Object)AccountCacheEvent.AccountCacheEventType.DELETE)) {
            return;
        }
        POP3MarkedCacheDAO pOP3MarkedCacheDAO = DefaultDAOFactory.getInstance().getPOP3MarkedCacheDAO();
        for (Account account : accountCacheEvent.getAccounts()) {
            if (!account.getIncomingServerProtocol().equals((Object)Protocol.POP3)) continue;
            try {
                pOP3MarkedCacheDAO.remove(account);
            }
            catch (DataBaseNegotiationException dataBaseNegotiationException) {
                logger.log(Level.SEVERE, dataBaseNegotiationException.getMessage(), dataBaseNegotiationException);
            }
        }
    }
}

