/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.db;

import java.util.HashMap;
import java.util.Map;
import net.sf.amemailchecker.db.common.proxy.ProxyDAOFactory;
import net.sf.amemailchecker.db.dao.AccountDAO;
import net.sf.amemailchecker.db.dao.FolderDAO;
import net.sf.amemailchecker.db.dao.LetterDAO;
import net.sf.amemailchecker.db.dao.LetterPartDAO;
import net.sf.amemailchecker.db.dao.POP3MarkedCacheDAO;
import net.sf.amemailchecker.db.dao.impl.AccountDAOImpl;
import net.sf.amemailchecker.db.dao.impl.FolderDAOImpl;
import net.sf.amemailchecker.db.dao.impl.LetterDAOImpl;
import net.sf.amemailchecker.db.dao.impl.LetterPartDAOImpl;
import net.sf.amemailchecker.db.dao.impl.POP3MarkedCacheDAOImpl;

public final class DefaultDAOFactory
extends ProxyDAOFactory {
    private static DefaultDAOFactory instance;
    private Map<Class, Object> cache = new HashMap<Class, Object>();

    private DefaultDAOFactory() {
    }

    public static DefaultDAOFactory getInstance() {
        if (instance == null) {
            instance = new DefaultDAOFactory();
        }
        return instance;
    }

    public POP3MarkedCacheDAO getPOP3MarkedCacheDAO() {
        return new POP3MarkedCacheDAOImpl();
    }

    public AccountDAO getAccountDAO() {
        return new AccountDAOImpl();
    }

    public synchronized FolderDAO getFolderDAO() {
        if (!this.cache.containsKey(FolderDAO.class)) {
            this.cache.put(FolderDAO.class, this.newFolderDAOInstance());
        }
        return (FolderDAO)this.cache.get(FolderDAO.class);
    }

    public FolderDAO newFolderDAOInstance() {
        return new FolderDAOImpl();
    }

    public LetterDAO getLetterDAO() {
        return new LetterDAOImpl();
    }

    public LetterPartDAO getLetterPartDAO() {
        return new LetterPartDAOImpl();
    }
}

