/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.db.common;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.amemailchecker.db.common.DBConnection;
import net.sf.amemailchecker.db.common.DBConnectionProperties;

class DBConnectionPool {
    private DBConnectionProperties configuration;
    private final List<DBConnection> pool = new ArrayList<DBConnection>();
    private final List<DBConnection> activePool = new ArrayList<DBConnection>();
    private int poolCleanCount = 15;
    private long expirationDelay = 30000L;

    DBConnectionPool(DBConnectionProperties dBConnectionProperties) {
        this.configuration = dBConnectionProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DBConnection get() throws SQLException {
        List<DBConnection> list = this.pool;
        synchronized (list) {
            if (this.pool.size() > this.poolCleanCount) {
                this.checkExpire();
            }
            DBConnection dBConnection = this.pool.size() > 0 ? this.pool.remove(this.pool.size() - 1) : this.create();
            this.activePool.add(dBConnection);
            return dBConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(Connection connection) {
        if (connection == null) {
            return;
        }
        List<DBConnection> list = this.pool;
        synchronized (list) {
            DBConnection dBConnection = this.findActive(connection);
            this.activePool.remove(dBConnection);
            this.pool.add(dBConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DBConnection findActive(Connection connection) {
        List<DBConnection> list = this.activePool;
        synchronized (list) {
            for (DBConnection dBConnection : this.activePool) {
                if (!dBConnection.getConnection().equals(connection)) continue;
                return dBConnection;
            }
            return null;
        }
    }

    private DBConnection create() throws SQLException {
        Connection connection = DriverManager.getConnection(this.configuration.getConnectionURL(), this.configuration.getUserName(), this.configuration.getPassword());
        return new DBConnection(connection, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkExpire() {
        List<DBConnection> list = this.pool;
        synchronized (list) {
            long l = System.currentTimeMillis();
            ArrayList<DBConnection> arrayList = new ArrayList<DBConnection>();
            for (DBConnection dBConnection : this.pool) {
                if (l - dBConnection.getCreationTime() <= this.expirationDelay) continue;
                arrayList.add(dBConnection);
            }
            for (DBConnection dBConnection : arrayList) {
                try {
                    dBConnection.getConnection().close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                this.pool.remove(dBConnection);
            }
        }
    }

    public int getPoolCleanCount() {
        return this.poolCleanCount;
    }

    public void setPoolCleanCount(int n) {
        this.poolCleanCount = n;
    }

    public long getExpirationDelay() {
        return this.expirationDelay;
    }

    public void setExpirationDelay(long l) {
        this.expirationDelay = l;
    }
}

