/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.db.common;

import java.sql.Connection;
import java.util.Properties;
import net.sf.amemailchecker.db.common.DBConnectionProperties;
import net.sf.amemailchecker.db.common.DBDataSource;

public class DBDataSourceFactory {
    private static DBDataSourceFactory instance;
    private DBDataSource dbDataSource;

    public static DBDataSourceFactory getInstance() {
        if (instance == null) {
            instance = new DBDataSourceFactory();
        }
        return instance;
    }

    private DBDataSourceFactory() {
    }

    public synchronized Connection getConnection() throws Exception {
        return this.dbDataSource.getConnection();
    }

    public synchronized void releaseConnection(Connection connection) {
        this.dbDataSource.releaseConnection(connection);
    }

    public void setConnectionProperties(Properties properties) throws Exception {
        this.dbDataSource = new DBDataSource(new DBConnectionProperties(properties));
    }
}

