/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.db.common;

import net.sf.amemailchecker.db.common.annotation.ColumnDefinition;
import net.sf.amemailchecker.db.common.annotation.Parameterized;
import net.sf.amemailchecker.db.common.annotation.Selector;
import net.sf.amemailchecker.db.common.annotation.TableDefinition;

public class DBQueryResolver {
    public String queryInsert(TableDefinition tableDefinition) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO ");
        stringBuilder.append(tableDefinition.scheme());
        stringBuilder.append(".");
        stringBuilder.append(tableDefinition.name());
        stringBuilder.append(" ( ");
        ColumnDefinition[] columnDefinitionArray = tableDefinition.columns();
        for (n = 0; n < columnDefinitionArray.length; ++n) {
            if (columnDefinitionArray[n].generated()) continue;
            stringBuilder.append(columnDefinitionArray[n].name());
            if (n >= columnDefinitionArray.length - 1) continue;
            stringBuilder.append(" , ");
        }
        stringBuilder.append(" ) VALUES (");
        for (n = 0; n < columnDefinitionArray.length; ++n) {
            if (columnDefinitionArray[n].generated()) continue;
            stringBuilder.append(" ? ");
            if (n >= columnDefinitionArray.length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String queryDelete(TableDefinition tableDefinition, Parameterized parameterized) {
        StringBuilder stringBuilder = this.queryDelete(tableDefinition);
        return this.parameters(tableDefinition, parameterized.parameters(), stringBuilder).toString();
    }

    public StringBuilder queryDelete(TableDefinition tableDefinition) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE FROM ");
        stringBuilder.append(tableDefinition.scheme());
        stringBuilder.append(".");
        stringBuilder.append(tableDefinition.name());
        stringBuilder.append(" ");
        stringBuilder.append(tableDefinition.name());
        return stringBuilder;
    }

    public String queryUpdate(TableDefinition tableDefinition, Parameterized parameterized) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE ");
        stringBuilder.append(tableDefinition.scheme());
        stringBuilder.append(".");
        stringBuilder.append(tableDefinition.name());
        stringBuilder.append(" SET ");
        ColumnDefinition[] columnDefinitionArray = tableDefinition.columns();
        for (int i = 0; i < columnDefinitionArray.length; ++i) {
            if (columnDefinitionArray[i].generated() || !columnDefinitionArray[i].updatable()) continue;
            stringBuilder.append(columnDefinitionArray[i].name());
            stringBuilder.append(" = ? ");
            if (i >= columnDefinitionArray.length - 1) continue;
            stringBuilder.append(" , ");
        }
        if (stringBuilder.charAt(stringBuilder.length() - 2) == ',') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 2);
        }
        return this.parameters(tableDefinition, parameterized.parameters(), stringBuilder).toString();
    }

    public String querySelectPartially(TableDefinition tableDefinition, Selector selector) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        for (int n : selector.selection()) {
            stringBuilder.append(tableDefinition.name());
            stringBuilder.append(".");
            stringBuilder.append(this.columnById(n, tableDefinition));
            stringBuilder.append(" ");
        }
        stringBuilder.append("FROM ");
        return this.querySelect(tableDefinition, selector, stringBuilder).toString();
    }

    public String querySelectCount(TableDefinition tableDefinition, Selector selector) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT COUNT(*) AS r FROM ( ");
        return stringBuilder.append(this.querySelect(tableDefinition, selector)).append(" )").toString();
    }

    public String querySelect(TableDefinition tableDefinition, Selector selector) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT * FROM ");
        return this.querySelect(tableDefinition, selector, stringBuilder).toString();
    }

    private StringBuilder querySelect(TableDefinition tableDefinition, Selector selector, StringBuilder stringBuilder) {
        stringBuilder.append(tableDefinition.scheme());
        stringBuilder.append(".");
        stringBuilder.append(tableDefinition.name());
        stringBuilder.append(" AS ");
        stringBuilder.append(tableDefinition.name());
        return this.parameters(tableDefinition, selector.parameters(), stringBuilder);
    }

    private StringBuilder parameters(TableDefinition tableDefinition, int[] nArray, StringBuilder stringBuilder) {
        stringBuilder.append(" WHERE ");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(tableDefinition.name());
            stringBuilder.append(".");
            stringBuilder.append(this.columnById(nArray[i], tableDefinition));
            stringBuilder.append(" = ?");
            if (i >= nArray.length - 1) continue;
            stringBuilder.append(" AND ");
        }
        return stringBuilder;
    }

    private String columnById(int n, TableDefinition tableDefinition) {
        for (ColumnDefinition columnDefinition : tableDefinition.columns()) {
            if (columnDefinition.id() != n) continue;
            return columnDefinition.name();
        }
        return null;
    }
}

