/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.db.common;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;

public abstract class LimitedObjectPool<T> {
    private final List<SoftReference<T>> pool = new ArrayList<SoftReference<T>>();
    private static final int MAX_COUNT = 20;
    private int count = 0;

    public synchronized int getPoolSize() {
        return this.pool.size();
    }

    public synchronized int getObjectCount() {
        return this.count;
    }

    public T get() throws InterruptedException {
        return this.waitFor();
    }

    private T remove() {
        while (this.pool.size() > 0) {
            SoftReference<T> softReference = this.pool.remove(this.pool.size() - 1);
            T t = softReference.get();
            if (t != null) {
                return t;
            }
            --this.count;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(T t) {
        List<SoftReference<T>> list = this.pool;
        synchronized (list) {
            this.pool.add(new SoftReference<T>(t));
            this.pool.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T waitFor() throws InterruptedException {
        List<SoftReference<T>> list = this.pool;
        synchronized (list) {
            T t = this.remove();
            if (t != null) {
                return t;
            }
            if (this.count < 20) {
                return this.create();
            }
            do {
                this.pool.wait();
            } while ((t = this.remove()) == null);
            return t;
        }
    }

    private T create() {
        T t = this.createObject();
        ++this.count;
        return t;
    }

    protected abstract T createObject();
}

