/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.db.dao.impl;

import java.sql.ResultSet;
import net.sf.amemailchecker.app.account.AccountBean;
import net.sf.amemailchecker.db.BaseJdbcObjectAwareDAO;
import net.sf.amemailchecker.db.common.DataBaseNegotiationException;
import net.sf.amemailchecker.db.common.annotation.ColumnDefinition;
import net.sf.amemailchecker.db.common.annotation.Parameterized;
import net.sf.amemailchecker.db.common.annotation.Parameterizes;
import net.sf.amemailchecker.db.common.annotation.Selector;
import net.sf.amemailchecker.db.common.annotation.TableDefinition;
import net.sf.amemailchecker.db.dao.AccountDAO;
import net.sf.amemailchecker.mail.model.Account;

@TableDefinition(name="ACCOUNT", scheme="AMC", columns={@ColumnDefinition(name="UUID", id=1)})
@Parameterizes(parameterizes={@Parameterized(name="UUID", parameters={1})})
@Selector(name="findByUUID", parameters={1})
public class AccountDAOImpl
extends BaseJdbcObjectAwareDAO<Account, String>
implements AccountDAO {
    @Override
    public void insert(Account account) throws DataBaseNegotiationException {
        this.executeQueryInsert(account.getUuid());
    }

    @Override
    public void delete(Account account) throws DataBaseNegotiationException {
        this.executeQueryDelete("delete", account.getUuid());
    }

    @Override
    public Account find(String string) throws DataBaseNegotiationException {
        return (Account)this.getSelectionOne("findByUUID", string);
    }

    @Override
    protected Account processResultSetForObject(ResultSet resultSet) throws Exception {
        AccountBean accountBean = new AccountBean();
        accountBean.setUuid(resultSet.getString(1));
        return accountBean;
    }
}

