/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.db.dao.impl;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import net.sf.amemailchecker.db.BaseJdbcObjectAwareDAO;
import net.sf.amemailchecker.db.common.DataBaseNegotiationException;
import net.sf.amemailchecker.db.common.annotation.ColumnDefinition;
import net.sf.amemailchecker.db.common.annotation.Parameterized;
import net.sf.amemailchecker.db.common.annotation.Parameterizes;
import net.sf.amemailchecker.db.common.annotation.Selector;
import net.sf.amemailchecker.db.common.annotation.TableDefinition;
import net.sf.amemailchecker.db.dao.FolderDAO;
import net.sf.amemailchecker.mail.impl.mailbox.LocalFolder;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;

@TableDefinition(name="FOLDER", scheme="AMC", columns={@ColumnDefinition(name="UUID", id=1, updatable=false), @ColumnDefinition(name="ACCOUNT_UUID", id=2, updatable=false), @ColumnDefinition(name="FOLDER_LABEL", id=3), @ColumnDefinition(name="CREATED_DATE", id=4, updatable=false)})
@Parameterizes(parameterizes={@Parameterized(name="UUID", parameters={1}), @Parameterized(name="deleteByAccount", parameters={2})})
@Selector(name="ByUUID", parameters={1})
public class FolderDAOImpl
extends BaseJdbcObjectAwareDAO<LocalFolder, String>
implements FolderDAO {
    @Override
    public void update(Folder folder) throws DataBaseNegotiationException {
        this.executeQueryUpdate("UUID", folder.getLabel(), ((LocalFolder)folder).getUuid());
    }

    @Override
    public void delete(Account account) throws DataBaseNegotiationException {
        this.executeQueryDelete("deleteByAccount", account.getUuid());
    }

    @Override
    public void delete(Folder folder) throws DataBaseNegotiationException {
        this.executeQueryDelete("UUID", ((LocalFolder)folder).getUuid());
        List list = (List)this.executeCustomSelect("loadFolderTreeOneLevel", "SELECT * FROM AMC.FOLDER AS F INNER JOIN AMC.FOLDER_REL AS R ON F.UUID = R.CHILD_UUID WHERE R.PARENT_UUID = ? ORDER BY F.CREATED_DATE ASC", ((LocalFolder)folder).getUuid());
        for (Folder folder2 : list) {
            this.delete(folder2);
        }
    }

    @Override
    public void insert(Folder folder, Folder folder2, Account account) throws DataBaseNegotiationException {
        this.executeQueryInsert(((LocalFolder)folder).getUuid(), account.getUuid(), folder.getLabel(), new Date());
        this.executeInsert("INSERT INTO AMC.FOLDER_REL (PARENT_UUID, CHILD_UUID) VALUES (?, ?)", folder2 != null ? ((LocalFolder)folder2).getUuid() : null, ((LocalFolder)folder).getUuid());
    }

    @Override
    public Folder find(String string) throws DataBaseNegotiationException {
        return (Folder)this.getSelectionOne("ByUUID", string);
    }

    @Override
    public List<Folder> load(String string) throws DataBaseNegotiationException {
        return (List)this.executeCustomSelect("loadFolderTree", "SELECT F.*, R.PARENT_UUID FROM AMC.FOLDER AS F INNER JOIN AMC.FOLDER_REL AS R ON F.UUID = R.CHILD_UUID WHERE F.ACCOUNT_UUID = ? ORDER BY F.CREATED_DATE ASC", string);
    }

    private List<Folder> loadFolderTree(ResultSet resultSet) throws Exception {
        TreeMap<String, LocalFolder> treeMap = new TreeMap<String, LocalFolder>();
        ArrayList<Folder> arrayList = new ArrayList<Folder>();
        while (resultSet.next()) {
            LocalFolder localFolder = this.processResultSetForObject(resultSet);
            String string = resultSet.getString(5);
            treeMap.put(localFolder.getUuid(), localFolder);
            if (string == null) {
                arrayList.add(localFolder);
                continue;
            }
            ((Folder)treeMap.get(string)).getChildren().add(localFolder);
        }
        return arrayList;
    }

    private List<Folder> loadFolderTreeOneLevel(ResultSet resultSet) throws Exception {
        ArrayList<Folder> arrayList = new ArrayList<Folder>();
        while (resultSet.next()) {
            LocalFolder localFolder = this.processResultSetForObject(resultSet);
            arrayList.add(localFolder);
        }
        return arrayList;
    }

    @Override
    protected LocalFolder processResultSetForObject(ResultSet resultSet) throws Exception {
        LocalFolder localFolder = new LocalFolder();
        localFolder.setUuid(resultSet.getString(1));
        localFolder.setLabel(resultSet.getString(3));
        return localFolder;
    }
}

