/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.db.dao.impl;

import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import net.sf.amemailchecker.db.BaseJdbcObjectAwareDAO;
import net.sf.amemailchecker.db.common.DataBaseNegotiationException;
import net.sf.amemailchecker.db.common.annotation.ColumnDefinition;
import net.sf.amemailchecker.db.common.annotation.Parameterized;
import net.sf.amemailchecker.db.common.annotation.Parameterizes;
import net.sf.amemailchecker.db.common.annotation.Selector;
import net.sf.amemailchecker.db.common.annotation.SelectorMode;
import net.sf.amemailchecker.db.common.annotation.Selectors;
import net.sf.amemailchecker.db.common.annotation.TableDefinition;
import net.sf.amemailchecker.db.dao.LetterDAO;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.impl.letter.RawMessagePart;
import net.sf.amemailchecker.mail.impl.mailbox.LocalFolder;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.Letter;

@TableDefinition(name="LETTER", scheme="AMC", columns={@ColumnDefinition(name="ID", id=1, generated=true), @ColumnDefinition(name="FOLDER_UUID", id=2), @ColumnDefinition(name="MESSAGE_UID", id=3), @ColumnDefinition(name="MESSAGE_ID", id=4), @ColumnDefinition(name="SUBJECT", id=5), @ColumnDefinition(name="DATE_RECEIVED", id=6)})
@Selectors(selectors={@Selector(name="findByUid", parameters={2, 3}), @Selector(name="findAllByFolder", parameters={2}), @Selector(name="count", mode=SelectorMode.COUNT, parameters={2}, resultSetRoutine="count"), @Selector(name="contains", mode=SelectorMode.COUNT, parameters={2, 3, 4}, resultSetRoutine="count")})
@Parameterizes(parameterizes={@Parameterized(name="delete", parameters={2, 3, 4}), @Parameterized(name="deleteByFolder", parameters={2})})
public class LetterDAOImpl
extends BaseJdbcObjectAwareDAO<Letter, Long>
implements LetterDAO {
    @Override
    public void move(Letter letter, Folder folder, Folder folder2) throws DataBaseNegotiationException {
        this.executeUpdate("UPDATE AMC.LETTER SET FOLDER_UUID = ? WHERE FOLDER_UUID = ? AND MESSAGE_UID = ? AND MESSAGE_ID = ?", ((LocalFolder)folder2).getUuid(), ((LocalFolder)folder).getUuid(), letter.getUid(), letter.getMessageID());
    }

    @Override
    public boolean contains(Folder folder, Letter letter) {
        try {
            int n = (Integer)this.executeSelectQuery("contains", ((LocalFolder)folder).getUuid(), letter.getUid(), letter.getMessageID());
            return n == 1;
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public int count(Folder folder) {
        try {
            return (Integer)this.executeSelectQuery("count", ((LocalFolder)folder).getUuid());
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, exception.getMessage(), exception);
            return 0;
        }
    }

    private int count(ResultSet resultSet) throws Exception {
        resultSet.next();
        return resultSet.getInt(1);
    }

    @Override
    public void delete(Letter letter, Folder folder) throws DataBaseNegotiationException {
        this.executeQueryDelete("delete", ((LocalFolder)folder).getUuid(), letter.getUid(), letter.getMessageID());
    }

    @Override
    public void delete(Folder folder) throws DataBaseNegotiationException {
        this.executeQueryDelete("deleteByFolder", ((LocalFolder)folder).getUuid());
    }

    @Override
    public long save(Letter letter, Folder folder) throws DataBaseNegotiationException {
        return (Long)this.executeQueryInsert(((LocalFolder)folder).getUuid(), letter.getUid(), letter.getMessageID(), letter.getSubject(), letter.getDate());
    }

    @Override
    public Letter findByUid(String string, Folder folder) throws DataBaseNegotiationException {
        return (Letter)this.getSelectionOne("findByUid", ((LocalFolder)folder).getUuid(), string);
    }

    @Override
    public List<Letter> findAll(Folder folder) throws DataBaseNegotiationException {
        return this.getSelectionList("findAllByFolder", ((LocalFolder)folder).getUuid());
    }

    @Override
    protected Letter processResultSetForObject(ResultSet resultSet) throws Exception {
        LetterImpl letterImpl = new LetterImpl(new RawMessagePart());
        letterImpl.setUid(resultSet.getString(3));
        letterImpl.setMessageID(resultSet.getString(4));
        letterImpl.setSubject(resultSet.getString(5));
        letterImpl.setDate(resultSet.getDate(6));
        return letterImpl;
    }
}

