/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.db.dao.impl;

import java.io.Reader;
import java.sql.Clob;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.sf.amemailchecker.db.BaseJdbcObjectAwareDAO;
import net.sf.amemailchecker.db.common.DataBaseNegotiationException;
import net.sf.amemailchecker.db.dao.LetterPartDAO;
import net.sf.amemailchecker.mail.impl.letter.RawMessagePart;
import net.sf.amemailchecker.mail.model.Letter;
import net.sf.amemailchecker.util.StringUtil;
import net.sf.amemailchecker.util.iterator.DefaultTreeGraphHierarchyIterator;

public class LetterPartDAOImpl
extends BaseJdbcObjectAwareDAO<RawMessagePart, Long>
implements LetterPartDAO {
    @Override
    public void deleteLetterStructure(long l) throws DataBaseNegotiationException {
        try {
            this.executeUpdate("DELETE FROM AMC.LETTER_PART AS P WHERE P.LETTER_ID = ?", l);
        }
        catch (Exception exception) {
            throw new DataBaseNegotiationException(exception);
        }
    }

    @Override
    public void storeLetterStructure(RawMessagePart rawMessagePart, long l) throws DataBaseNegotiationException {
        DefaultTreeGraphHierarchyIterator<RawMessagePart> defaultTreeGraphHierarchyIterator = new DefaultTreeGraphHierarchyIterator<RawMessagePart>(new RawMessagePart[]{rawMessagePart}){

            public Collection children(Object object) {
                return ((RawMessagePart)object).getBodyParts();
            }
        };
        HashMap<RawMessagePart, Long> hashMap = new HashMap<RawMessagePart, Long>();
        while (defaultTreeGraphHierarchyIterator.hasNext()) {
            RawMessagePart rawMessagePart2 = (RawMessagePart)defaultTreeGraphHierarchyIterator.next();
            if (defaultTreeGraphHierarchyIterator.parent() == null) {
                hashMap.put(rawMessagePart2, null);
            }
            long l2 = this.insertLetterPart(rawMessagePart2, l);
            if (hashMap.containsKey(rawMessagePart2)) {
                this.executeInsert("INSERT INTO AMC.LETTER_PART_REL ( PARENT_ID, CHILD_ID ) VALUES (?, ?)", hashMap.get(rawMessagePart2), l2);
            }
            for (Object e : defaultTreeGraphHierarchyIterator.children((Object)rawMessagePart2)) {
                RawMessagePart rawMessagePart3 = (RawMessagePart)e;
                hashMap.put(rawMessagePart3, l2);
            }
        }
    }

    private long insertLetterPart(RawMessagePart rawMessagePart, long l) throws DataBaseNegotiationException {
        Long l2 = (Long)this.executeInsert("INSERT INTO AMC.LETTER_PART ( LETTER_ID, PAYLOAD ) VALUES ( ?, ? )", l, rawMessagePart.getPayload().size() > 0 ? StringUtil.appendTokensDelimiter(rawMessagePart.getPayload(), (String)"\r\n") : null);
        for (String string : rawMessagePart.getHeaders().keySet()) {
            this.executeInsert("INSERT INTO AMC.PART_HEADER ( LETTER_PART_ID, HEADER_NAME, HEADER_VALUE ) VALUES( ?, ?, ? )", l2, string, rawMessagePart.getHeaderValue(string));
        }
        return l2;
    }

    @Override
    public RawMessagePart loadLetterStructure(long l) throws DataBaseNegotiationException {
        return (RawMessagePart)this.executeCustomSelect("loadLetterStructure", "SELECT P.*, R.PARENT_ID FROM AMC.LETTER_PART AS P \nINNER JOIN AMC.LETTER_PART_REL AS R ON P.ID = R.CHILD_ID \nWHERE P.LETTER_ID = ? ORDER BY R.PARENT_ID", l);
    }

    @Override
    public RawMessagePart loadLetterStructure(Letter letter) throws DataBaseNegotiationException {
        return (RawMessagePart)this.executeCustomSelect("loadLetterStructure", "SELECT P.*, R.PARENT_ID FROM AMC.LETTER_PART AS P \nINNER JOIN AMC.LETTER_PART_REL AS R ON P.ID = R.CHILD_ID \nINNER JOIN AMC.LETTER AS L ON P.LETTER_ID = L.ID \nWHERE L.MESSAGE_UID = ? AND L.MESSAGE_ID = ? ORDER BY R.PARENT_ID", letter.getUid(), letter.getMessageID());
    }

    private RawMessagePart loadLetterStructure(ResultSet resultSet) throws Exception {
        TreeMap<Long, RawMessagePart> treeMap = new TreeMap<Long, RawMessagePart>();
        while (resultSet.next()) {
            long l = resultSet.getLong(1);
            RawMessagePart rawMessagePart = this.processResultSetForObject(resultSet);
            long l2 = resultSet.getLong(4);
            if (treeMap.containsKey(l2)) {
                ((RawMessagePart)treeMap.get(l2)).getBodyParts().add(rawMessagePart);
            }
            treeMap.put(l, rawMessagePart);
            Map map = (Map)this.executeCustomSelect("loadPartHeaders", "SELECT P.HEADER_NAME, P.HEADER_VALUE FROM AMC.PART_HEADER AS P WHERE P.LETTER_PART_ID = ?", l);
            rawMessagePart.setHeaders(map);
        }
        return !treeMap.isEmpty() ? (RawMessagePart)treeMap.firstEntry().getValue() : null;
    }

    private Map<String, String> loadPartHeaders(ResultSet resultSet) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (resultSet.next()) {
            hashMap.put(resultSet.getString(1), resultSet.getString(2));
        }
        return hashMap;
    }

    @Override
    protected RawMessagePart processResultSetForObject(ResultSet resultSet) throws Exception {
        RawMessagePart rawMessagePart = new RawMessagePart();
        Clob clob = resultSet.getClob(3);
        if (clob != null) {
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[128];
            Reader reader = clob.getCharacterStream();
            while (reader.read(cArray) != -1) {
                stringBuffer.append(cArray);
                Arrays.fill(cArray, '\u0000');
            }
            rawMessagePart.getPayload().addAll(StringUtil.dropToTokens((String)stringBuffer.toString().trim(), (String)"\r\n"));
        }
        return rawMessagePart;
    }
}

