/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.db.dao.impl;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import net.sf.amemailchecker.db.BaseJdbcDAO;
import net.sf.amemailchecker.db.common.DataBaseNegotiationException;
import net.sf.amemailchecker.db.common.annotation.ColumnDefinition;
import net.sf.amemailchecker.db.common.annotation.Parameterized;
import net.sf.amemailchecker.db.common.annotation.Parameterizes;
import net.sf.amemailchecker.db.common.annotation.Selector;
import net.sf.amemailchecker.db.common.annotation.SelectorMode;
import net.sf.amemailchecker.db.common.annotation.Selectors;
import net.sf.amemailchecker.db.common.annotation.TableDefinition;
import net.sf.amemailchecker.db.dao.POP3MarkedCacheDAO;
import net.sf.amemailchecker.mail.model.Account;

@TableDefinition(name="POP3_MARKED_READ_CACHE", scheme="AMC", columns={@ColumnDefinition(name="ACCOUNT_UID", id=1), @ColumnDefinition(name="MESSAGE_UID", id=2)})
@Parameterizes(parameterizes={@Parameterized(parameters={1}, name="deleteByAccount"), @Parameterized(parameters={1, 2}, name="deleteTarget")})
@Selectors(selectors={@Selector(name="contains", parameters={1, 2}, mode=SelectorMode.COUNT, resultSetRoutine="contains"), @Selector(name="selectAllByAccount", parameters={1}, mode=SelectorMode.PARTIALLY, selection={2}, resultSetRoutine="selectAllByAccount")})
public class POP3MarkedCacheDAOImpl
extends BaseJdbcDAO
implements POP3MarkedCacheDAO {
    @Override
    public void insert(Account account, String ... stringArray) throws DataBaseNegotiationException {
        for (String string : stringArray) {
            this.executeQueryInsert(account.getUuid(), string);
        }
    }

    @Override
    public void remove(Account account) throws DataBaseNegotiationException {
        this.executeQueryDelete("deleteByAccount", account.getUuid());
    }

    @Override
    public void remove(Account account, String ... stringArray) throws DataBaseNegotiationException {
        try {
            for (String string : stringArray) {
                this.executeQueryDelete("deleteTarget", account.getUuid(), string);
            }
        }
        catch (Exception exception) {
            throw new DataBaseNegotiationException(exception);
        }
    }

    @Override
    public boolean contains(Account account, String string) throws DataBaseNegotiationException {
        return (Boolean)this.executeSelectQuery("contains", account.getUuid(), string);
    }

    private boolean contains(ResultSet resultSet) throws Exception {
        resultSet.first();
        return resultSet.getInt(1) == 1;
    }

    @Override
    public List<String> selectAllByAccount(Account account) throws DataBaseNegotiationException {
        return (List)this.executeSelectQuery("selectAllByAccount", account.getUuid());
    }

    private List<String> selectAllByAccount(ResultSet resultSet) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (resultSet.next()) {
            arrayList.add(resultSet.getString(1));
        }
        return arrayList;
    }
}

