/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.entrypoint;

import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.extension.EntryPointExtensionPoint;
import net.sf.amemailchecker.app.extension.ExtensionInfo;
import net.sf.amemailchecker.app.extension.ExtensionProvider;
import net.sf.amemailchecker.app.state.StateContext;
import net.sf.amemailchecker.command.CommandExecutionService;
import net.sf.amemailchecker.command.impl.app.ShowMailNotificationCommand;
import net.sf.amemailchecker.command.impl.mail.CheckUnreadMultipleCommand;
import net.sf.amemailchecker.command.timer.TimerWrapper;
import net.sf.amemailchecker.gui.AboutScreen;
import net.sf.amemailchecker.gui.entrypoint.AppEntryPoint;
import net.sf.amemailchecker.gui.entrypoint.EntryPointFactory;
import net.sf.amemailchecker.gui.entrypoint.EntryPointPopupMenu;
import net.sf.amemailchecker.gui.entrypoint.EntryPointStateManager;
import net.sf.amemailchecker.gui.settings.SettingsMediator;

public class EntryPointMediator
implements Observer {
    private static final Logger logger = Logger.getLogger(EntryPointMediator.class.getName());
    private AppEntryPoint entryPoint;
    private EntryPointStateManager stateManager;

    public void showAboutScreen() {
        new Thread(){

            @Override
            public void run() {
                new AboutScreen().showNotification(20);
            }
        }.start();
    }

    public void notifyAgain() {
        CommandExecutionService.Service.executeCommandSilent(new ShowMailNotificationCommand(true));
    }

    public void checkMail() {
        CommandExecutionService.Service.executeCommandSilent(new CheckUnreadMultipleCommand());
    }

    public void exitApplication() {
        ((TimerWrapper)ApplicationContext.getInstance().getObject(TimerWrapper.class.getName())).discardTimer();
        for (ExtensionInfo object : ExtensionProvider.Provider.getExtensions()) {
            object.getExtension().shutdown();
        }
        boolean bl = CommandExecutionService.Service.containsSubmittedCommands();
        if (bl) {
            AppEntryPoint appEntryPoint = this.getEntryPoint();
            appEntryPoint.showNotificationMessage(ApplicationContext.getInstance().getI18NBundleValue("message.exit.waiting"));
            appEntryPoint.removeListeners();
            while (bl) {
                bl = CommandExecutionService.Service.containsSubmittedCommands();
            }
        }
        System.exit(0);
    }

    public void displaySettingsDialog() {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        SettingsMediator settingsMediator = (SettingsMediator)applicationContext.getObject(SettingsMediator.class.getName());
        if (settingsMediator == null) {
            settingsMediator = new SettingsMediator(this);
            settingsMediator.showSettingsDialog();
            applicationContext.setObject(settingsMediator);
        } else {
            if (settingsMediator.getSettingsDialog().getExtendedState() == 1) {
                settingsMediator.getSettingsDialog().setExtendedState(0);
            }
            settingsMediator.getSettingsDialog().toFront();
        }
    }

    public void changeEntryPoint(int n) {
        this.entryPoint.removePoint();
        EntryPointFactory.removeEntryPoint(n);
        try {
            this.createPoint(n);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Unable to change Entry Point: " + exception.getMessage(), exception);
        }
        this.stateManager.setState(this.stateManager.getCurrentState(), this.entryPoint);
    }

    public void initialize(int n) throws Exception {
        this.stateManager = new EntryPointStateManager();
        this.createPoint(n);
    }

    private void createPoint(int n) throws Exception {
        this.entryPoint = EntryPointFactory.getEntryPoint(n);
        EntryPointPopupMenu entryPointPopupMenu = new EntryPointPopupMenu(this);
        for (EntryPointExtensionPoint entryPointExtensionPoint : ExtensionProvider.Provider.getEntryPointExtensions()) {
            entryPointExtensionPoint.register(entryPointPopupMenu.getDelegate());
        }
        this.entryPoint.setPopupMenu(entryPointPopupMenu);
        this.entryPoint.addPoint();
    }

    @Override
    public void update(Observable observable, Object object) {
        StateContext stateContext = (StateContext)observable;
        this.stateManager.setState(stateContext.getCurrentState(), this.entryPoint);
    }

    public AppEntryPoint getEntryPoint() {
        return this.entryPoint;
    }
}

