/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.entrypoint;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.gui.ActionControlFactory;
import net.sf.amemailchecker.gui.entrypoint.EntryPointMediator;
import net.sf.amemailchecker.gui.entrypoint.EntryPointMenu;

public class EntryPointPopupMenu
extends JPopupMenu {
    private JMenuItem notifyAgain;
    private JMenuItem checkMail;
    private JMenuItem settings;
    private JMenuItem about;
    private JMenuItem exit;
    private EntryPointMediator mediator;
    private int top;
    private int middle;
    private int bottom;

    public EntryPointPopupMenu(EntryPointMediator entryPointMediator) {
        this.mediator = entryPointMediator;
        this.init();
    }

    private void init() {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        ActionControlFactory actionControlFactory = ActionControlFactory.Factory;
        this.notifyAgain = actionControlFactory.getJMenuItem(applicationContext.getI18NBundleValue("action.notify.label"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntryPointPopupMenu.this.mediator.notifyAgain();
            }
        });
        this.checkMail = actionControlFactory.getJMenuItem(applicationContext.getI18NBundleValue("action.checkmail.label"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntryPointPopupMenu.this.mediator.checkMail();
            }
        });
        this.settings = actionControlFactory.getJMenuItem(applicationContext.getI18NBundleValue("dialog.settings.title"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntryPointPopupMenu.this.mediator.displaySettingsDialog();
            }
        });
        this.about = actionControlFactory.getJMenuItem(applicationContext.getI18NBundleValue("action.about.label"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntryPointPopupMenu.this.mediator.showAboutScreen();
            }
        });
        this.exit = actionControlFactory.getJMenuItem(applicationContext.getI18NBundleValue("action.exit.label"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntryPointPopupMenu.this.mediator.exitApplication();
            }
        });
        this.add(this.notifyAgain);
        this.add(this.checkMail);
        this.addSeparator();
        this.add(this.settings);
        this.add(this.about);
        this.add(this.exit);
        this.top = 2;
        this.bottom = this.middle = this.top + 1;
    }

    public JMenuItem getNotifyAgain() {
        return this.notifyAgain;
    }

    public JMenuItem getCheckMail() {
        return this.checkMail;
    }

    public void insert(JMenuItem jMenuItem, EntryPointMenu.MenuLayout menuLayout, boolean bl) {
        super.insert(jMenuItem, this.determinePosition(menuLayout, bl));
        if (this.middle == 6) {
            super.add((Component)new JPopupMenu.Separator(), this.middle);
        }
    }

    private int determinePosition(EntryPointMenu.MenuLayout menuLayout, boolean bl) {
        int n = 0;
        switch (menuLayout) {
            case TOP: {
                n = bl ? 0 : this.top;
                ++this.top;
                ++this.middle;
                ++this.bottom;
                break;
            }
            case MIDDLE: {
                n = bl ? this.middle : this.bottom;
                ++this.middle;
                ++this.bottom;
            }
        }
        return n;
    }

    EntryPointMenu getDelegate() {
        return new EntryPointPopupMenuDelegate();
    }

    private class EntryPointPopupMenuDelegate
    implements EntryPointMenu {
        private EntryPointPopupMenuDelegate() {
        }

        public void insert(JMenuItem jMenuItem, EntryPointMenu.MenuLayout menuLayout, boolean bl) {
            EntryPointPopupMenu.this.insert(jMenuItem, menuLayout, bl);
        }
    }
}

