/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.entrypoint;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.gui.entrypoint.AppEntryPoint;
import net.sf.amemailchecker.gui.entrypoint.tray.EntryPointTrayIcon;
import net.sf.amemailchecker.gui.entrypoint.window.EntryPointWindow;

public enum EntryPointType {
    TRAY_ICON(0, EntryPointTrayIcon.class.getName(), "label.tray.icon"),
    DOCKLET(1, EntryPointWindow.class.getName(), "label.docklet");

    private static Logger logger;
    private int id;
    private String className;
    private String titleKey;
    private AppEntryPoint instance;

    private EntryPointType(int n2, String string2, String string3) {
        this.id = n2;
        this.className = string2;
        this.titleKey = string3;
    }

    public int getId() {
        return this.id;
    }

    public String getTitleKey() {
        return this.titleKey;
    }

    public String getPackageName() {
        return this.name().toLowerCase().replaceAll("_", "");
    }

    public AppEntryPoint getInstance() {
        if (this.instance == null) {
            try {
                this.instance = (AppEntryPoint)Class.forName(this.className).newInstance();
                this.instance.setType(this);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        return this.instance;
    }

    public void removeInstance() {
        this.instance = null;
    }

    public static EntryPointType getById(int n) {
        for (EntryPointType entryPointType : EntryPointType.values()) {
            if (entryPointType.getId() != n) continue;
            return entryPointType;
        }
        return null;
    }

    static {
        logger = Logger.getLogger(EntryPointType.class.getName());
    }
}

