/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.entrypoint.tray;

import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import net.sf.amemailchecker.gui.entrypoint.BaseEntryPoint;

public class EntryPointTrayIcon
extends BaseEntryPoint {
    private TrayIcon icon;

    @Override
    public void addPoint() throws Exception {
        this.icon = new TrayIcon(new BufferedImage(1, 1, 1));
        this.icon.setImageAutoSize(true);
        this.icon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.evaluatePopup(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.evaluatePopup(mouseEvent);
            }

            private void evaluatePopup(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    return;
                }
                EntryPointTrayIcon.this.popupMenu.setLocation(mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen() - ((EntryPointTrayIcon)EntryPointTrayIcon.this).popupMenu.getPreferredSize().height);
                EntryPointTrayIcon.this.popupMenu.setInvoker(EntryPointTrayIcon.this.popupMenu);
                EntryPointTrayIcon.this.popupMenu.setVisible(true);
            }
        });
        SystemTray.getSystemTray().add(this.icon);
    }

    @Override
    public String getToolTip() {
        return this.icon.getToolTip();
    }

    @Override
    public void setImage(Image image) {
        this.icon.setImage(image);
    }

    @Override
    public void setToolTip(String string) {
        this.icon.setToolTip(string);
    }

    @Override
    public void removePoint() {
        this.icon.setPopupMenu(null);
        SystemTray.getSystemTray().remove(this.icon);
    }

    @Override
    public void removeListeners() {
        MouseListener[] mouseListenerArray;
        for (MouseListener mouseListener : mouseListenerArray = this.icon.getMouseListeners()) {
            this.icon.removeMouseListener(mouseListener);
        }
    }

    @Override
    public void showNotificationMessage(String string) {
        this.icon.displayMessage("", string, TrayIcon.MessageType.INFO);
    }
}

