/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.entrypoint.window;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import net.sf.amemailchecker.gui.entrypoint.BaseEntryPoint;
import net.sf.amemailchecker.gui.entrypoint.window.EntryPointWindowMouseListener;
import net.sf.amemailchecker.gui.notification.splash.SimpleSplashWindow;
import net.sf.amemailchecker.gui.notification.window.tooltip.ToolTipMouseListener;
import net.sf.amemailchecker.gui.notification.window.tooltip.ToolTipNotificationWindow;

public class EntryPointWindow
extends BaseEntryPoint {
    private SimpleSplashWindow window = new SimpleSplashWindow();
    private ToolTipMouseListener.Configuration toolTipConfiguration;

    @Override
    public void addPoint() {
        this.window.add((Component)this.popupMenu);
        EntryPointWindowMouseListener entryPointWindowMouseListener = new EntryPointWindowMouseListener((Component)this.window, this.popupMenu);
        this.window.addMouseListener((MouseListener)((Object)entryPointWindowMouseListener));
        this.window.addMouseMotionListener((MouseMotionListener)((Object)entryPointWindowMouseListener));
        this.toolTipConfiguration = new ToolTipMouseListener.Configuration(2, "", (Component)this.window);
        ToolTipMouseListener toolTipMouseListener = new ToolTipMouseListener(this.toolTipConfiguration);
        this.window.addMouseListener((MouseListener)toolTipMouseListener);
        this.window.addMouseMotionListener((MouseMotionListener)toolTipMouseListener);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.window.setLocation(dimension.width / 2 - this.window.getWidth() / 2, dimension.height / 2 - this.window.getHeight() / 2);
        this.window.setAlwaysOnTop(true);
        this.window.setVisible(true);
    }

    @Override
    public String getToolTip() {
        return this.toolTipConfiguration.getMessage();
    }

    @Override
    public void setImage(Image image) {
        this.window.updateImage(image);
    }

    @Override
    public void setToolTip(String string) {
        this.toolTipConfiguration.setMessage(string);
    }

    @Override
    public void removePoint() {
        this.window.setVisible(false);
    }

    @Override
    public void showNotificationMessage(String string) {
        new ToolTipNotificationWindow(string, (Component)this.window).showNotification();
    }

    @Override
    public void removeListeners() {
        MouseListener[] mouseListenerArray;
        for (MouseListener mouseListener : mouseListenerArray = this.window.getMouseListeners()) {
            this.window.removeMouseListener(mouseListener);
        }
    }
}

