/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer;

import java.awt.GraphicsEnvironment;
import javax.swing.JFrame;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.account.AccountCacheEvent;
import net.sf.amemailchecker.app.extension.viewer.MessageViewerContext;
import net.sf.amemailchecker.app.notification.NotificationCacheEvent;
import net.sf.amemailchecker.gui.messageviewer.DefaultMessageViewerContext;
import net.sf.amemailchecker.gui.messageviewer.MessageViewerMediator;
import net.sf.amemailchecker.gui.messageviewer.MessageViewerPreferences;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.Letter;
import net.sf.amemailchecker.util.GenericObservable;
import net.sf.amemailchecker.util.GenericObserver;

public enum MessageViewer {
    Viewer;

    private AccountsCacheObserver accountsCacheObserver = new AccountsCacheObserver();
    private NotificationCacheObserver notificationCacheObserver = new NotificationCacheObserver();
    private ApplicationContext context = ApplicationContext.getInstance();
    private DefaultMessageViewerContext viewerContext;
    private boolean active;

    public void show(Account account, Folder folder, Letter letter) {
        this.show(new Creator(account, folder, letter));
    }

    public void show(Account account, Folder folder) {
        this.show(new Creator(account, folder));
    }

    public void show(Account account) {
        this.show(new Creator(account));
    }

    public void show() {
        this.show(new Creator());
    }

    private MessageViewerMediator show(Creator creator) {
        boolean bl = this.context.getUserData().getMessageViewerPreferences().isCloseMessageViewerToEntryPoint();
        MessageViewerMediator messageViewerMediator = this.getMediator();
        messageViewerMediator = bl && !this.active && this.isPersisted() ? messageViewerMediator : (this.active ? messageViewerMediator : creator.create());
        this.show(messageViewerMediator);
        if (this.active || bl && !this.active) {
            creator.update(messageViewerMediator);
        }
        return messageViewerMediator;
    }

    private void show(MessageViewerMediator messageViewerMediator) {
        JFrame jFrame = this.viewerContext.getParentContainer();
        if (!this.active) {
            boolean bl = this.isPersisted();
            if (!bl) {
                jFrame.setSize(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getSize());
            }
            jFrame.setVisible(true);
            if (!bl) {
                jFrame.setExtendedState(6);
                this.context.setObject(messageViewerMediator);
            }
            this.active = true;
        } else {
            if (jFrame.getExtendedState() == 1) {
                jFrame.setExtendedState(0);
            }
            jFrame.toFront();
        }
    }

    public void hide() {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        this.viewerContext.getParentContainer().setVisible(false);
        if (!applicationContext.getUserData().getMessageViewerPreferences().isCloseMessageViewerToEntryPoint()) {
            applicationContext.removeObject(MessageViewerMediator.class.getName());
        }
        this.active = false;
    }

    public boolean isPersisted() {
        return this.context.containsObject(MessageViewerMediator.class.getName());
    }

    public void preferencesChanged(MessageViewerPreferences messageViewerPreferences) {
        if (!this.isPersisted()) {
            return;
        }
        MessageViewerMediator messageViewerMediator = this.getMediator();
        messageViewerMediator.refreshAccount();
    }

    public void registerAccountsCacheObservable(GenericObservable<AccountCacheEvent> genericObservable) {
        genericObservable.addObserver((GenericObserver)this.accountsCacheObserver);
    }

    public void registerNotificationCacheObservable(GenericObservable<NotificationCacheEvent> genericObservable) {
        genericObservable.addObserver((GenericObserver)this.notificationCacheObserver);
    }

    private MessageViewerMediator getMediator() {
        return (MessageViewerMediator)this.context.getObject(MessageViewerMediator.class.getName());
    }

    public MessageViewerContext getContext() {
        return this.viewerContext;
    }

    private class NotificationCacheObserver
    implements GenericObserver<NotificationCacheEvent> {
        private NotificationCacheObserver() {
        }

        public void updatePerformed(NotificationCacheEvent notificationCacheEvent) {
            if (!MessageViewer.this.isPersisted()) {
                return;
            }
            MessageViewerMediator messageViewerMediator = MessageViewer.this.getMediator();
            switch (notificationCacheEvent.getType()) {
                case NEW: {
                    messageViewerMediator.update(notificationCacheEvent.getAccount(), notificationCacheEvent.getLetters());
                    break;
                }
                case REMOVED: {
                    messageViewerMediator.update(notificationCacheEvent.getAccount());
                    break;
                }
                case MARKED: {
                    messageViewerMediator.update(notificationCacheEvent.getAccount());
                }
            }
        }
    }

    private class AccountsCacheObserver
    implements GenericObserver<AccountCacheEvent> {
        private AccountsCacheObserver() {
        }

        public void updatePerformed(AccountCacheEvent accountCacheEvent) {
            if (!MessageViewer.this.isPersisted()) {
                return;
            }
            MessageViewerMediator messageViewerMediator = MessageViewer.this.getMediator();
            Account[] accountArray = accountCacheEvent.getAccounts();
            switch (accountCacheEvent.getType()) {
                case EDIT: {
                    messageViewerMediator.editAccount(accountArray);
                    break;
                }
                case DELETE: {
                    messageViewerMediator.deleteAccount(accountArray);
                    break;
                }
                case INSERT: {
                    messageViewerMediator.insertAccount(accountArray);
                    break;
                }
                case STATUS: {
                    messageViewerMediator.statusAccount(accountArray);
                }
            }
        }
    }

    private class Creator {
        private Account account;
        private Folder folder;
        private Letter message;

        public Creator(Account account, Folder folder, Letter letter) {
            this.account = account;
            this.folder = folder;
            this.message = letter;
        }

        public Creator(Account account, Folder folder) {
            this.account = account;
            this.folder = folder;
        }

        public Creator(Account account) {
            this.account = account;
        }

        public Creator() {
        }

        public MessageViewerMediator create() {
            MessageViewer.this.viewerContext = new DefaultMessageViewerContext();
            return new MessageViewerMediator(MessageViewer.this.viewerContext);
        }

        public void update(MessageViewerMediator messageViewerMediator) {
            if (this.message != null) {
                messageViewerMediator.update(this.account);
                messageViewerMediator.update(this.folder);
                messageViewerMediator.update(this.message);
                return;
            }
            if (this.folder != null) {
                messageViewerMediator.update(this.account);
                messageViewerMediator.update(this.folder);
                return;
            }
            if (this.account != null) {
                messageViewerMediator.update(this.account);
            }
        }
    }
}

