/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.app.extension.DefaultMailActionContext;
import net.sf.amemailchecker.app.extension.ExtensionProvider;
import net.sf.amemailchecker.app.extension.MailActionContext;
import net.sf.amemailchecker.app.extension.MailActionContextChangeListener;
import net.sf.amemailchecker.app.extension.letter.LetterDetailsActionExtensionPoint;
import net.sf.amemailchecker.app.extension.viewer.ViewerExtensionPoint;
import net.sf.amemailchecker.app.notification.NotificationCache;
import net.sf.amemailchecker.command.CommandExecutionService;
import net.sf.amemailchecker.db.DefaultDAOFactory;
import net.sf.amemailchecker.db.common.DataBaseNegotiationException;
import net.sf.amemailchecker.db.dao.LetterPartDAO;
import net.sf.amemailchecker.gui.ActionButtonPanel;
import net.sf.amemailchecker.gui.ActionControlFactory;
import net.sf.amemailchecker.gui.BaseFrame;
import net.sf.amemailchecker.gui.component.accordion.AccordionBar;
import net.sf.amemailchecker.gui.component.accordion.AccordionBarInfo;
import net.sf.amemailchecker.gui.component.accordion.AccordionBarModel;
import net.sf.amemailchecker.gui.component.accordion.AccordionBarModelChangeListener;
import net.sf.amemailchecker.gui.component.container.LabeledViewport;
import net.sf.amemailchecker.gui.component.tree.CheckedValueTreeModel;
import net.sf.amemailchecker.gui.messageviewer.DefaultMessageViewerContext;
import net.sf.amemailchecker.gui.messageviewer.MessageViewer;
import net.sf.amemailchecker.gui.messageviewer.foldertree.DefaultFolderTreeMediator;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.MessageDetailsMediator;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.MessageDetailsPanel;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.MessageTabbedPane;
import net.sf.amemailchecker.gui.messageviewer.messagetable.DefaultLettersTableMediator;
import net.sf.amemailchecker.gui.messageviewer.statusbar.StatusBar;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.FolderType;
import net.sf.amemailchecker.mail.model.Letter;
import net.sf.amemailchecker.mail.parser.MailMessageParser;

public final class MessageViewerMediator {
    private ApplicationContext appContext = ApplicationContext.getInstance();
    private JFrame messageViewerFrame;
    private DefaultLettersTableMediator messageTableMediator;
    private MessageDetailsMediator messageDetailsMediator;
    private MessageTabbedPane messageTabbedPane;
    private DefaultFolderTreeMediator folderTreeMediator;
    private ActionButtonPanel buttonsPanel;
    private DefaultMessageViewerContext context;

    public MessageViewerMediator(DefaultMessageViewerContext defaultMessageViewerContext) {
        this.context = defaultMessageViewerContext;
        this.messageTableMediator = new DefaultLettersTableMediator();
        this.messageDetailsMediator = new MessageDetailsMediator(defaultMessageViewerContext);
        this.messageTabbedPane = new MessageTabbedPane();
        this.folderTreeMediator = new DefaultFolderTreeMediator();
        defaultMessageViewerContext.setLettersTable(this.messageTableMediator);
        defaultMessageViewerContext.setLettersTabbedPane(this.messageTabbedPane);
        defaultMessageViewerContext.setFolderTree(this.folderTreeMediator);
        defaultMessageViewerContext.setLetterDetails(this.messageDetailsMediator);
        this.messageViewerFrame = this.component();
        defaultMessageViewerContext.setParentContainer(this.messageViewerFrame);
        Collection<Account> collection = this.appContext.getUserData().getMessageViewerPreferences().isRemoveDisabledFromAccountsView() ? this.appContext.getAccountsCache().getActiveAccounts() : this.appContext.getAccountsCache().getAccounts();
        this.insertAccount(collection.toArray(new Account[collection.size()]));
    }

    void update(Account account) {
        this.context.setAccount(account);
        this.folderTreeMediator.setSelectedAccount(account);
        this.messageTableMediator.clear();
        Folder folder = this.folderTreeMediator.getRemoteFolderTree(account).getSelectedFolder();
        if (folder != null) {
            this.update(folder);
        }
    }

    void update(Folder folder) {
        this.contextChanged(folder);
        this.folderTreeMediator.getRemoteFolderTree(this.context.getAccount()).clearSelection();
        this.folderTreeMediator.getRemoteFolderTree(this.context.getAccount()).setSelectedFolder(folder);
    }

    void update(final Letter letter) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessageViewerMediator.this.messageTableMediator.setSingleSelected(letter);
            }
        });
    }

    synchronized void deleteAccount(Account ... accountArray) {
        for (Account account : accountArray) {
            this.folderTreeMediator.remove(account);
        }
        if (!this.folderTreeMediator.contains(this.context.getAccount())) {
            if (this.folderTreeMediator.size() == 0) {
                this.context.setAccount(null);
                this.context.setFolder(null);
                this.messageTableMediator.clear();
                return;
            }
            this.update(this.context.getAccount());
        }
    }

    synchronized void insertAccount(Account ... accountArray) {
        if (this.context.getAccount() == null && accountArray.length > 0) {
            this.context.setAccount(accountArray[0]);
        }
        for (Account account : accountArray) {
            if (this.folderTreeMediator.contains(account)) continue;
            this.folderTreeMediator.insert(account);
        }
    }

    synchronized void statusAccount(Account ... accountArray) {
        boolean bl = this.appContext.getUserData().getMessageViewerPreferences().isRemoveDisabledFromAccountsView();
        for (Account account : accountArray) {
            if (account.isActive() && !this.folderTreeMediator.contains(account)) {
                this.insertAccount(account);
                continue;
            }
            if (!bl) continue;
            this.deleteAccount(account);
        }
    }

    synchronized void editAccount(Account ... accountArray) {
        for (Account account : accountArray) {
            this.folderTreeMediator.update(account);
        }
    }

    synchronized void refreshAccount() {
        boolean bl = this.appContext.getUserData().getMessageViewerPreferences().isRemoveDisabledFromAccountsView();
        for (Account account : this.appContext.getAccountsCache().getAccounts()) {
            boolean bl2 = this.folderTreeMediator.contains(account);
            if (bl && bl2 && !account.isActive()) {
                this.deleteAccount(account);
                continue;
            }
            if (!(bl || bl2 || account.isActive())) {
                this.insertAccount(account);
                continue;
            }
            if (!bl2) continue;
            this.folderTreeMediator.update(account);
        }
    }

    synchronized void update(Account account, Map<Folder, List<Letter>> map) {
        this.folderTreeMediator.getRemoteFolderTree(this.folderTreeMediator.getSelectedAccount()).refresh();
        if (!account.equals(this.context.getAccount())) {
            return;
        }
        Folder folder = this.folderTreeMediator.getRemoteFolderTree(account).getSelectedFolder();
        if (folder == null) {
            return;
        }
        for (Folder folder2 : map.keySet()) {
            if (!folder.equals(folder2)) continue;
            List<Letter> list = map.get(folder2);
            this.messageTableMediator.insert(false, list.toArray(new Letter[list.size()]));
            break;
        }
        this.contextChanged(this.context);
    }

    public void contextChanged(MailActionContext mailActionContext) {
        List<ViewerExtensionPoint> list = ExtensionProvider.Provider.getViewerExtensionPoints();
        for (ViewerExtensionPoint viewerExtensionPoint : list) {
            MailActionContextChangeListener mailActionContextChangeListener = viewerExtensionPoint.listener();
            if (mailActionContextChangeListener == null) continue;
            mailActionContextChangeListener.contextChanged(mailActionContext, this.buttonsPanel.getActionButtons(viewerExtensionPoint.getClass().getName()));
        }
    }

    private void contextChanged(Folder folder) {
        this.context.setFolder(folder);
        this.folderTreeMediator.select(this.context.getAccount(), folder);
    }

    private JFrame component() {
        Object object;
        if (this.messageViewerFrame != null) {
            return this.messageViewerFrame;
        }
        BaseFrame baseFrame = new BaseFrame((ResourceContext)this.appContext);
        baseFrame.setTitle(this.appContext.getI18NBundleValue("dialog.message.viewer.title"));
        final JTable jTable = this.messageTableMediator.component();
        JScrollPane jScrollPane = new JScrollPane();
        final LabeledViewport labeledViewport = new LabeledViewport();
        jScrollPane.setViewport((JViewport)labeledViewport);
        jScrollPane.getViewport().add(jTable);
        this.buttonsPanel = new ActionButtonPanel();
        List<ViewerExtensionPoint> list = ExtensionProvider.Provider.getViewerExtensionPoints();
        for (ViewerExtensionPoint object22 : list) {
            object = object22.controls(MessageViewer.Viewer.getContext());
            if (object == null) continue;
            this.buttonsPanel.addActionButtons((AbstractButton[])object, object22.getClass().getName());
        }
        AccordionBar accordionBar = this.folderTreeMediator.component();
        final MessageDetailsPanel messageDetailsPanel = this.messageDetailsMediator.component((Window)baseFrame, LetterDetailsActionExtensionPoint.State.VIEW);
        jTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 1 || tableModelEvent.getType() == -1) {
                    boolean bl = jTable.getRowCount() > 0 && !jTable.getSelectionModel().isSelectionEmpty() && jTable.getSelectedRowCount() == 1;
                    messageDetailsPanel.switchPanels(bl);
                }
            }
        });
        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = jTable.getRowCount() > 0 && !jTable.getSelectionModel().isSelectionEmpty() && jTable.getSelectedRowCount() == 1;
                messageDetailsPanel.switchPanels(bl);
                if (bl) {
                    MessageViewerMediator.this.messageDetailsMediator.expandLetterDetails(MessageViewerMediator.this.messageTableMediator.getSingle(false));
                }
            }
        });
        object = new JSplitPane();
        ((JSplitPane)object).setOrientation(0);
        ((JSplitPane)object).setResizeWeight(0.5);
        ((JSplitPane)object).setOneTouchExpandable(true);
        ((JSplitPane)object).setTopComponent(jScrollPane);
        ((JSplitPane)object).setBottomComponent(messageDetailsPanel);
        final StatusBar statusBar = new StatusBar((JFrame)baseFrame);
        CommandExecutionService.Service.addCommandExecutionObserver(statusBar.getProgressBarEventObserver());
        accordionBar.getModel().addModelChangeListener(new AccordionBarModelChangeListener(){

            public void barAdded(ChangeEvent changeEvent) {
            }

            public void barRemoved(ChangeEvent changeEvent) {
            }

            public void barSelected(ChangeEvent changeEvent) {
                final AccordionBarModel accordionBarModel = (AccordionBarModel)changeEvent.getSource();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AccordionBarInfo accordionBarInfo = accordionBarModel.getVisibleBarInfo();
                        Account account = MessageViewerMediator.this.appContext.getAccountsCache().getByUuid(accordionBarInfo.getName());
                        if (!account.equals(MessageViewerMediator.this.context.getAccount())) {
                            MessageViewerMediator.this.update(account);
                        }
                        statusBar.setInfoText(MessageViewerMediator.this.context.getAccount().getTitle());
                        boolean bl = MessageViewerMediator.this.context.getAccount().isActive();
                        labeledViewport.setDrawLabel(!bl);
                        if (!bl) {
                            labeledViewport.setLabel(MessageViewerMediator.this.appContext.getI18NBundleValue("message.account.is.disabled"));
                        }
                    }
                });
            }
        });
        this.folderTreeMediator.addFolderTreeSelectionChangeListener(FolderType.REMOTE, new FolderTreeSelectionListener(){

            @Override
            protected void updateStatuses(Folder folder) {
                statusBar.setInfoText(MessageViewerMediator.this.context.getAccount().getTitle() + " - " + MessageViewerMediator.this.appContext.getI18NBundleValue("label.remote") + "  [" + MessageViewerMediator.this.context.getFolder().getLabel() + "]");
                boolean bl = NotificationCache.getInstance().containsLetters(MessageViewerMediator.this.context.getAccount(), MessageViewerMediator.this.context.getFolder());
                labeledViewport.setDrawLabel(!bl || !MessageViewerMediator.this.context.getFolder().isEnabled());
                if (!MessageViewerMediator.this.context.getFolder().isEnabled()) {
                    labeledViewport.setLabel(MessageViewerMediator.this.appContext.getI18NBundleValue("message.folder.checking.disabled"));
                } else if (!bl) {
                    labeledViewport.setLabel(MessageViewerMediator.this.appContext.getI18NBundleValue("message.no.new.letters.in.folder"));
                }
            }

            @Override
            protected List<Letter> letters(Folder folder) {
                return NotificationCache.getInstance().get(MessageViewerMediator.this.context.getAccount(), folder);
            }
        });
        this.folderTreeMediator.addFolderTreeSelectionChangeListener(FolderType.LOCAL, new FolderTreeSelectionListener(){

            @Override
            protected void updateStatuses(Folder folder) {
                statusBar.setInfoText(MessageViewerMediator.this.context.getAccount().getTitle() + " - " + MessageViewerMediator.this.appContext.getI18NBundleValue("label.local") + "  [" + MessageViewerMediator.this.context.getFolder().getLabel() + "]");
                boolean bl = DefaultDAOFactory.getInstance().getLetterDAO().count(folder) > 0;
                labeledViewport.setDrawLabel(!bl);
                if (!bl) {
                    labeledViewport.setLabel(MessageViewerMediator.this.appContext.getI18NBundleValue("message.no.letters.in.folder"));
                }
            }

            @Override
            protected List<Letter> letters(Folder folder) {
                List<Letter> list;
                try {
                    list = DefaultDAOFactory.getInstance().getLetterDAO().findAll(folder);
                    LetterPartDAO letterPartDAO = DefaultDAOFactory.getInstance().getLetterPartDAO();
                    for (Letter letter : list) {
                        ((LetterImpl)letter).setRawMessage(letterPartDAO.loadLetterStructure(letter));
                        MailMessageParser mailMessageParser = new MailMessageParser();
                        mailMessageParser.parseFromHeader((LetterImpl)letter);
                        mailMessageParser.parseAddresseesHeader((LetterImpl)letter, "CC");
                        mailMessageParser.parseAddresseesHeader((LetterImpl)letter, "To");
                        mailMessageParser.processBody(((LetterImpl)letter).getRawMessage(), (LetterImpl)letter);
                    }
                }
                catch (DataBaseNegotiationException dataBaseNegotiationException) {
                    dataBaseNegotiationException.printStackTrace();
                    list = new ArrayList<Letter>();
                }
                return list;
            }
        });
        this.folderTreeMediator.addFolderChangeListener(FolderType.LOCAL, new ContextFolderChangeListener());
        this.folderTreeMediator.addFolderChangeListener(FolderType.REMOTE, new ContextFolderChangeListener());
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setOrientation(1);
        jSplitPane.setLeftComponent((Component)accordionBar);
        jSplitPane.setRightComponent((Component)object);
        this.messageTabbedPane.addTab(this.appContext.getI18NBundleValue("action.messages.label"), jSplitPane, false);
        baseFrame.getContentPane().setLayout(new BorderLayout());
        baseFrame.getContentPane().add((Component)this.buttonsPanel, "North");
        baseFrame.getContentPane().add((Component)((Object)this.messageTabbedPane), "Center");
        baseFrame.getContentPane().add((Component)statusBar, "South");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(this.appContext.getI18NBundleValue("menu.label"));
        jMenu.add(ActionControlFactory.Factory.getJMenuItem(this.appContext.getI18NBundleValue("action.close.label"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MessageViewer.Viewer.hide();
            }
        }));
        jMenuBar.add(jMenu);
        baseFrame.setJMenuBar(jMenuBar);
        baseFrame.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosed(windowEvent);
                MessageViewer.Viewer.hide();
            }
        });
        return baseFrame;
    }

    private abstract class FolderTreeSelectionListener
    implements TreeSelectionListener {
        private FolderTreeSelectionListener() {
        }

        protected abstract void updateStatuses(Folder var1);

        protected abstract List<Letter> letters(Folder var1);

        @Override
        public void valueChanged(final TreeSelectionEvent treeSelectionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                    if (treePath == null) {
                        return;
                    }
                    Folder folder = (Folder)((CheckedValueTreeModel)((JTree)treeSelectionEvent.getSource()).getModel()).valueByPath(treePath);
                    FolderTreeSelectionListener.this.updateStatuses(folder);
                    List<Letter> list = FolderTreeSelectionListener.this.letters(folder);
                    MessageViewerMediator.this.messageTableMediator.insert(true, list.toArray(new Letter[list.size()]));
                    DefaultMailActionContext defaultMailActionContext = new DefaultMailActionContext();
                    defaultMailActionContext.setAccount(MessageViewerMediator.this.context.getAccount());
                    defaultMailActionContext.setFolder(MessageViewerMediator.this.context.getFolder());
                    MessageViewerMediator.this.contextChanged(defaultMailActionContext);
                }
            });
        }
    }

    private class ContextFolderChangeListener
    extends MouseAdapter {
        private ContextFolderChangeListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() != 1 && mouseEvent.getClickCount() != 1) {
                return;
            }
            JTree jTree = (JTree)mouseEvent.getComponent();
            TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreePath treePath2 = jTree.getSelectionPath();
            if (treePath == null || treePath2 == null) {
                return;
            }
            Folder folder = (Folder)((CheckedValueTreeModel)jTree.getModel()).valueByPath(treePath);
            MessageViewerMediator.this.contextChanged(folder);
        }
    }
}

