/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.extension.action;

import java.util.Arrays;
import java.util.List;
import net.sf.amemailchecker.app.extension.viewer.MessageViewerContext;
import net.sf.amemailchecker.command.CommandExecutionService;
import net.sf.amemailchecker.command.impl.mail.CopyLettersCommand;
import net.sf.amemailchecker.command.task.DefaultCommandExecutableTask;
import net.sf.amemailchecker.gui.component.table.SelectionMode;
import net.sf.amemailchecker.gui.component.tree.CheckedValueTreeModel;
import net.sf.amemailchecker.gui.component.tree.DefaultCheckedValueTreeModel;
import net.sf.amemailchecker.gui.component.tree.TreeModelFilter;
import net.sf.amemailchecker.gui.messageviewer.extension.action.CopyLettersBaseAction;
import net.sf.amemailchecker.mail.Protocol;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.Letter;

public class CopyLettersAction
extends CopyLettersBaseAction {
    public CopyLettersAction(String string, MessageViewerContext messageViewerContext, SelectionMode selectionMode) {
        super(string, messageViewerContext, selectionMode);
    }

    @Override
    protected List<Folder> folders(Account account) {
        return account.getMailBox().getFolders();
    }

    @Override
    protected CheckedValueTreeModel<Folder> model() {
        DefaultCheckedValueTreeModel defaultCheckedValueTreeModel = new DefaultCheckedValueTreeModel();
        defaultCheckedValueTreeModel.addFilter((TreeModelFilter)new TreeModelFilter<Folder>(){

            public boolean isVisible(Folder folder) {
                return folder.isSelectable();
            }
        });
        return defaultCheckedValueTreeModel;
    }

    @Override
    protected void listener(Letter[] letterArray) {
        CopyLettersCommand copyLettersCommand = new CopyLettersCommand(this.context.getAccount(), this.context.getFolder(), this.to, Arrays.asList(letterArray));
        DefaultCommandExecutableTask defaultCommandExecutableTask = new DefaultCommandExecutableTask(copyLettersCommand);
        CommandExecutionService.Service.executeNotify(defaultCommandExecutableTask);
    }

    @Override
    public boolean isEnabled() {
        if (this.context.getAccount().getIncomingServerProtocol().equals((Object)Protocol.POP3)) {
            return false;
        }
        return super.isEnabled();
    }
}

