/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.extension.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.app.extension.viewer.MessageViewerContext;
import net.sf.amemailchecker.gui.BaseDialog;
import net.sf.amemailchecker.gui.component.table.SelectionMode;
import net.sf.amemailchecker.gui.component.tree.CheckedValueTreeModel;
import net.sf.amemailchecker.gui.component.tree.TreeModelHierarchyIterator;
import net.sf.amemailchecker.gui.messageviewer.extension.action.MessageViewerAction;
import net.sf.amemailchecker.gui.messageviewer.foldertree.FolderTreeModelHierarchyIterator;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.Letter;

abstract class CopyLettersBaseAction
extends MessageViewerAction {
    protected SelectionMode mode;
    protected Folder to;

    public CopyLettersBaseAction(String string, MessageViewerContext messageViewerContext, SelectionMode selectionMode) {
        super(string, messageViewerContext);
        this.mode = selectionMode;
    }

    protected abstract List<Folder> folders(Account var1);

    protected abstract CheckedValueTreeModel<Folder> model();

    protected abstract void listener(Letter[] var1);

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.performAction(this.letters(this.mode, false));
    }

    protected void performAction(final Letter[] letterArray) {
        final CheckedValueTreeModel<Folder> checkedValueTreeModel = this.model();
        checkedValueTreeModel.insert((TreeModelHierarchyIterator)new FolderTreeModelHierarchyIterator(this.folders(this.context.getAccount()), false));
        final JTree jTree = new JTree();
        jTree.setModel((TreeModel)checkedValueTreeModel);
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        BaseDialog baseDialog = new BaseDialog(this.context.getParentContainer(), true){

            public void init(ResourceContext resourceContext) {
                super.init(resourceContext);
                this.cancel.setText(resourceContext.getI18NBundleValue("action.cancel.label"));
                this.accept.setText(resourceContext.getI18NBundleValue("action.accept.label"));
                this.getContentPane().setLayout(new BorderLayout());
                this.getContentPane().add((Component)this.commonButtonPanel, "South");
                JScrollPane jScrollPane = new JScrollPane();
                jScrollPane.getViewport().add(jTree);
                this.getContentPane().add((Component)jScrollPane, "Center");
                jTree.addTreeSelectionListener(new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                        Folder folder = (Folder)checkedValueTreeModel.valueByPath(treeSelectionEvent.getPath());
                        accept.setEnabled(!folder.equals(CopyLettersBaseAction.this.context.getFolder()));
                        CopyLettersBaseAction.this.to = folder;
                    }
                });
                this.accept.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.setVisible(false);
                        if (letterArray == null || letterArray.length == 0) {
                            return;
                        }
                        CopyLettersBaseAction.this.listener(letterArray);
                    }
                });
                this.accept.setEnabled(false);
                this.pack();
                this.setAutoLocation();
            }
        };
        baseDialog.init((ResourceContext)ApplicationContext.getInstance());
        baseDialog.setVisible(true);
    }

    @Override
    public boolean isEnabled() {
        switch (this.mode) {
            case CHECKED: {
                return this.context.getLettersTable().getChecked(false).length > 0;
            }
            case SELECTED: {
                return this.context.getLettersTable().hasSelection();
            }
        }
        return !this.context.getLettersTable().empty();
    }
}

