/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.extension.action;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.extension.viewer.MessageViewerContext;
import net.sf.amemailchecker.db.DefaultDAOFactory;
import net.sf.amemailchecker.db.common.DataBaseNegotiationException;
import net.sf.amemailchecker.db.dao.LetterDAO;
import net.sf.amemailchecker.db.dao.LetterPartDAO;
import net.sf.amemailchecker.gui.component.table.SelectionMode;
import net.sf.amemailchecker.gui.component.tree.CheckedValueTreeModel;
import net.sf.amemailchecker.gui.component.tree.DefaultCheckedValueTreeModel;
import net.sf.amemailchecker.gui.messageviewer.MessageViewer;
import net.sf.amemailchecker.gui.messageviewer.extension.action.CopyLettersBaseAction;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.Letter;

public class CopyLettersLocalAction
extends CopyLettersBaseAction {
    private static final Logger logger = Logger.getLogger(CopyLettersLocalAction.class.getName());

    public CopyLettersLocalAction(String string, MessageViewerContext messageViewerContext, SelectionMode selectionMode) {
        super(string, messageViewerContext, selectionMode);
    }

    @Override
    protected CheckedValueTreeModel<Folder> model() {
        return new DefaultCheckedValueTreeModel();
    }

    @Override
    protected List<Folder> folders(Account account) {
        List<Folder> list;
        try {
            list = DefaultDAOFactory.getInstance().getFolderDAO().load(account.getUuid());
        }
        catch (DataBaseNegotiationException dataBaseNegotiationException) {
            logger.log(Level.INFO, "Unable to load list of local folders for account " + account);
            logger.log(Level.SEVERE, dataBaseNegotiationException.getMessage(), dataBaseNegotiationException);
            list = new ArrayList<Folder>();
        }
        return list;
    }

    @Override
    protected void listener(Letter[] letterArray) {
        int n;
        if (this.containsUnfetched(letterArray) && (n = JOptionPane.showConfirmDialog(this.context.getParentContainer(), ApplicationContext.getInstance().getI18NBundleValue("message.local.copy.contains.unfetched"), "", 2, 2)) == 2) {
            return;
        }
        LetterDAO letterDAO = DefaultDAOFactory.getInstance().getLetterDAO();
        LetterPartDAO letterPartDAO = DefaultDAOFactory.getInstance().getLetterPartDAO();
        for (Letter letter : letterArray) {
            try {
                if (!letter.isFetched() || letterDAO.contains(this.to, letter)) continue;
                long l = letterDAO.save(letter, this.to);
                letterPartDAO.storeLetterStructure(((LetterImpl)letter).getRawMessage(), l);
            }
            catch (DataBaseNegotiationException dataBaseNegotiationException) {
                logger.log(Level.INFO, "Unable to save letter " + letter.getMessageID() + " to local folder " + this.to.getName());
                logger.log(Level.SEVERE, dataBaseNegotiationException.getMessage(), dataBaseNegotiationException);
            }
        }
        MessageViewer.Viewer.getContext().getFolderTree().getLocalFolderTree(this.context.getAccount()).refresh();
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.downloaded();
    }

    private boolean downloaded() {
        Letter[] letterArray = this.letters(this.mode, false);
        int n = 0;
        for (Letter letter : this.letters(this.mode, false)) {
            if (letter.isFetched()) continue;
            ++n;
        }
        return n != letterArray.length;
    }

    private boolean containsUnfetched(Letter[] letterArray) {
        for (Letter letter : letterArray) {
            if (letter.isFetched()) continue;
            return true;
        }
        return false;
    }
}

