/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.extension.action;

import java.awt.event.ActionEvent;
import java.util.List;
import net.sf.amemailchecker.app.extension.viewer.MessageViewerContext;
import net.sf.amemailchecker.command.CommandExecutionListener;
import net.sf.amemailchecker.command.CommandExecutionService;
import net.sf.amemailchecker.command.impl.mail.FetchMessageCommand;
import net.sf.amemailchecker.command.task.CommandExecutable;
import net.sf.amemailchecker.command.task.DefaultCommandExecutableTask;
import net.sf.amemailchecker.gui.component.table.SelectionMode;
import net.sf.amemailchecker.gui.messageviewer.extension.action.MessageViewerAction;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.FolderType;
import net.sf.amemailchecker.mail.model.Letter;

public class FetchAction
extends MessageViewerAction {
    private SelectionMode mode;

    public FetchAction(MessageViewerContext messageViewerContext) {
        super(messageViewerContext);
    }

    public FetchAction(String string, MessageViewerContext messageViewerContext, SelectionMode selectionMode) {
        super(string, messageViewerContext);
        this.mode = selectionMode;
    }

    public void performFetchAction(Account account, Folder folder, Letter ... letterArray) {
        if (letterArray == null || letterArray.length == 0) {
            return;
        }
        FetchMessageCommand fetchMessageCommand = new FetchMessageCommand(account, folder, letterArray);
        DefaultCommandExecutableTask defaultCommandExecutableTask = new DefaultCommandExecutableTask(fetchMessageCommand);
        defaultCommandExecutableTask.addCommandExecutionListener(new CommandExecutionListener<List<LetterImpl>>(){

            @Override
            public void beforeExecution(CommandExecutable<List<LetterImpl>> commandExecutable) {
            }

            @Override
            public void afterExecution(CommandExecutable<List<LetterImpl>> commandExecutable) {
                if (commandExecutable.isErrorOccured()) {
                    return;
                }
                List<LetterImpl> list = commandExecutable.getExecutionResult();
                LetterImpl letterImpl = list.get(0);
                FetchAction.this.context.getLettersTabbedPane().update((Letter)letterImpl);
                Letter letter = FetchAction.this.context.getLettersTable().getSingle(false);
                if (letter.equals(letterImpl)) {
                    FetchAction.this.context.getLetterDetails().expandLetterDetails((Letter)letterImpl);
                }
            }
        });
        CommandExecutionService.Service.executeNotify(defaultCommandExecutableTask);
    }

    public void performFetchAction(Account account, Folder folder, SelectionMode selectionMode) {
        this.performFetchAction(account, folder, this.letters(selectionMode, false));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.performFetchAction(this.context.getAccount(), this.context.getFolder(), this.mode);
    }

    @Override
    public boolean isEnabled() {
        Folder folder = this.context.getFolder();
        if (folder == null || folder.getType().equals((Object)FolderType.LOCAL)) {
            return false;
        }
        switch (this.mode) {
            case CHECKED: {
                return this.context.getLettersTable().getChecked(false).length > 0 && this.downloaded();
            }
            case SELECTED: {
                return this.downloaded() && this.context.getLettersTable().hasSelection();
            }
        }
        return !this.context.getLettersTable().empty() && this.downloaded();
    }

    private boolean downloaded() {
        for (Letter letter : this.letters(this.mode, false)) {
            if (letter.isFetched()) continue;
            return true;
        }
        return false;
    }
}

