/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.extension.action;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.extension.MailActionContext;
import net.sf.amemailchecker.app.extension.viewer.FolderTree;
import net.sf.amemailchecker.app.extension.viewer.MessageViewerContext;
import net.sf.amemailchecker.command.CommandExecutionListener;
import net.sf.amemailchecker.command.CommandExecutionService;
import net.sf.amemailchecker.command.impl.mail.CreateFolderCommand;
import net.sf.amemailchecker.command.task.CommandExecutable;
import net.sf.amemailchecker.command.task.DefaultCommandExecutableTask;
import net.sf.amemailchecker.gui.messageviewer.MessageViewer;
import net.sf.amemailchecker.gui.messageviewer.extension.action.FolderAction;
import net.sf.amemailchecker.mail.Protocol;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.util.StringUtil;

public class FolderCreateAction
extends FolderAction {
    public FolderCreateAction(String string, MailActionContext mailActionContext) {
        super(string, mailActionContext);
    }

    public void performFolderCreateAction() {
        String string = JOptionPane.showInputDialog(ApplicationContext.getInstance().getI18NBundleValue("message.enter.folder.name"));
        if (StringUtil.isNullOrEmpty((String)string)) {
            return;
        }
        DefaultCommandExecutableTask defaultCommandExecutableTask = new DefaultCommandExecutableTask(new CreateFolderCommand(this.context.getAccount(), string, this.context.getFolder()));
        defaultCommandExecutableTask.addCommandExecutionListener(new CommandExecutionListener<Folder>(){

            @Override
            public void beforeExecution(CommandExecutable<Folder> commandExecutable) {
            }

            @Override
            public void afterExecution(CommandExecutable<Folder> commandExecutable) {
                if (!commandExecutable.isErrorOccured() && commandExecutable.isExecutionPerformed()) {
                    Folder folder = commandExecutable.getExecutionResult();
                    MessageViewerContext messageViewerContext = MessageViewer.Viewer.getContext();
                    FolderTree folderTree = messageViewerContext.getFolderTree().getRemoteFolderTree(FolderCreateAction.this.context.getAccount());
                    Folder folder2 = folderTree.getSelectedFolder();
                    folderTree.insert(folder, FolderCreateAction.this.context.getFolder());
                    folderTree.setSelectedFolder(folder2);
                }
            }
        });
        CommandExecutionService.Service.executeNotify(defaultCommandExecutableTask);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.performFolderCreateAction();
    }

    @Override
    public boolean isEnabled() {
        if (this.context.getAccount().getIncomingServerProtocol().equals((Object)Protocol.POP3)) {
            return false;
        }
        Folder folder = this.context.getFolder();
        return folder == null || folder.isChildrenAllowed() && super.isEnabled();
    }
}

