/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.extension.action;

import java.awt.event.ActionEvent;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.extension.MailActionContext;
import net.sf.amemailchecker.db.DefaultDAOFactory;
import net.sf.amemailchecker.db.common.DataBaseNegotiationException;
import net.sf.amemailchecker.db.dao.AccountDAO;
import net.sf.amemailchecker.db.dao.FolderDAO;
import net.sf.amemailchecker.gui.messageviewer.MessageViewer;
import net.sf.amemailchecker.mail.impl.mailbox.LocalFolder;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.FolderType;
import net.sf.amemailchecker.util.StringUtil;

public class FolderCreateLocalAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(FolderCreateLocalAction.class.getName());
    private MailActionContext context;

    public FolderCreateLocalAction(String string, MailActionContext mailActionContext) {
        super(string);
        this.context = mailActionContext;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Account account;
        AccountDAO accountDAO;
        String string = JOptionPane.showInputDialog(ApplicationContext.getInstance().getI18NBundleValue("message.enter.folder.name"));
        if (StringUtil.isNullOrEmpty((String)string)) {
            return;
        }
        Folder folder = this.context.getFolder();
        FolderDAO folderDAO = DefaultDAOFactory.getInstance().getFolderDAO();
        LocalFolder localFolder = new LocalFolder(UUID.randomUUID().toString());
        localFolder.setLabel(string);
        try {
            accountDAO = DefaultDAOFactory.getInstance().getAccountDAO();
            account = accountDAO.find(this.context.getAccount().getUuid());
            if (account == null) {
                accountDAO.insert(this.context.getAccount());
            }
            folderDAO.insert(localFolder, folder, this.context.getAccount());
        }
        catch (DataBaseNegotiationException dataBaseNegotiationException) {
            logger.log(Level.INFO, "Unable to create local folder " + localFolder.getName() + " for account " + this.context.getAccount());
            logger.log(Level.SEVERE, dataBaseNegotiationException.getMessage(), dataBaseNegotiationException);
            return;
        }
        accountDAO = MessageViewer.Viewer.getContext();
        account = accountDAO.getFolderTree().getLocalFolderTree(this.context.getAccount());
        Folder folder2 = account.getSelectedFolder();
        account.insert((Folder)localFolder, this.context.getFolder());
        account.setSelectedFolder(folder2);
    }

    @Override
    public boolean isEnabled() {
        Folder folder = this.context.getFolder();
        return (folder == null || folder.getType().equals((Object)FolderType.LOCAL)) && super.isEnabled();
    }
}

