/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.extension.action;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import net.sf.amemailchecker.app.extension.MailActionContext;
import net.sf.amemailchecker.app.extension.viewer.FolderTree;
import net.sf.amemailchecker.db.DefaultDAOFactory;
import net.sf.amemailchecker.db.common.DataBaseNegotiationException;
import net.sf.amemailchecker.gui.messageviewer.MessageViewer;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.FolderType;

public class FolderDeleteLocalAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(FolderDeleteLocalAction.class.getName());
    private MailActionContext context;

    public FolderDeleteLocalAction(String string, MailActionContext mailActionContext) {
        super(string);
        this.context = mailActionContext;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Account account = this.context.getAccount();
        Folder folder = this.context.getFolder();
        FolderTree folderTree = MessageViewer.Viewer.getContext().getFolderTree().getLocalFolderTree(account);
        try {
            DefaultDAOFactory.getInstance().getFolderDAO().delete(folder);
        }
        catch (DataBaseNegotiationException dataBaseNegotiationException) {
            logger.log(Level.INFO, "Unable to delete local folder " + folder.getName() + " for account " + account);
            logger.log(Level.SEVERE, dataBaseNegotiationException.getMessage(), dataBaseNegotiationException);
            return;
        }
        Folder folder2 = folderTree.delete(folder);
        if (folder2 != null) {
            folderTree.setSelectedFolder(folder2);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.context.getFolder().getType().equals((Object)FolderType.LOCAL) && super.isEnabled();
    }
}

