/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.extension.action;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.extension.MailActionContext;
import net.sf.amemailchecker.command.CommandExecutionListener;
import net.sf.amemailchecker.command.CommandExecutionService;
import net.sf.amemailchecker.command.impl.mail.RenameFolderCommand;
import net.sf.amemailchecker.command.task.CommandExecutable;
import net.sf.amemailchecker.command.task.DefaultCommandExecutableTask;
import net.sf.amemailchecker.gui.messageviewer.MessageViewer;
import net.sf.amemailchecker.gui.messageviewer.extension.action.FolderAction;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.util.StringUtil;

public class FolderRenameAction
extends FolderAction {
    public FolderRenameAction(String string, MailActionContext mailActionContext) {
        super(string, mailActionContext);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = JOptionPane.showInputDialog(ApplicationContext.getInstance().getI18NBundleValue("message.enter.folder.name"));
        if (StringUtil.isNullOrEmpty((String)string)) {
            return;
        }
        Account account = this.context.getAccount();
        Folder folder = this.context.getFolder();
        DefaultCommandExecutableTask defaultCommandExecutableTask = new DefaultCommandExecutableTask(new RenameFolderCommand(account, folder, string));
        defaultCommandExecutableTask.addCommandExecutionListener(new CommandExecutionListener<Folder>(){

            @Override
            public void beforeExecution(CommandExecutable<Folder> commandExecutable) {
            }

            @Override
            public void afterExecution(CommandExecutable<Folder> commandExecutable) {
                if (!commandExecutable.isErrorOccured() && commandExecutable.isExecutionPerformed()) {
                    MessageViewer.Viewer.getContext().getFolderTree().getRemoteFolderTree(FolderRenameAction.this.context.getAccount()).refresh();
                }
            }
        });
        CommandExecutionService.Service.executeNotify(defaultCommandExecutableTask);
    }

    @Override
    public boolean isEnabled() {
        return this.context.getFolder().isSelectable() && super.isEnabled();
    }
}

