/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.extension.action;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.extension.MailActionContext;
import net.sf.amemailchecker.db.DefaultDAOFactory;
import net.sf.amemailchecker.db.common.DataBaseNegotiationException;
import net.sf.amemailchecker.gui.messageviewer.MessageViewer;
import net.sf.amemailchecker.mail.impl.mailbox.LocalFolder;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.FolderType;
import net.sf.amemailchecker.util.StringUtil;

public class FolderRenameLocalAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(FolderRenameLocalAction.class.getName());
    private MailActionContext context;

    public FolderRenameLocalAction(String string, MailActionContext mailActionContext) {
        super(string);
        this.context = mailActionContext;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = JOptionPane.showInputDialog(ApplicationContext.getInstance().getI18NBundleValue("message.enter.folder.name"));
        if (StringUtil.isNullOrEmpty((String)string)) {
            return;
        }
        Account account = this.context.getAccount();
        LocalFolder localFolder = (LocalFolder)this.context.getFolder();
        localFolder.setLabel(string);
        try {
            DefaultDAOFactory.getInstance().getFolderDAO().update(localFolder);
        }
        catch (DataBaseNegotiationException dataBaseNegotiationException) {
            logger.log(Level.INFO, "Unable to rename local folder " + localFolder.getName() + " for account " + account);
            logger.log(Level.SEVERE, dataBaseNegotiationException.getMessage(), dataBaseNegotiationException);
        }
        MessageViewer.Viewer.getContext().getFolderTree().getLocalFolderTree(account).refresh();
    }

    @Override
    public boolean isEnabled() {
        return this.context.getFolder().getType().equals((Object)FolderType.LOCAL) && super.isEnabled();
    }
}

