/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.extension.action;

import net.sf.amemailchecker.app.extension.viewer.LettersTableMediator;
import net.sf.amemailchecker.app.extension.viewer.MessageViewerContext;
import net.sf.amemailchecker.command.CommandErrorHandler;
import net.sf.amemailchecker.command.CommandExecutionService;
import net.sf.amemailchecker.command.exception.CommandExecutionException;
import net.sf.amemailchecker.command.impl.mail.MailServiceCommand;
import net.sf.amemailchecker.command.task.DefaultCommandExecutableTask;
import net.sf.amemailchecker.gui.component.table.SelectionMode;
import net.sf.amemailchecker.gui.messageviewer.MessageViewer;
import net.sf.amemailchecker.gui.messageviewer.extension.action.MessageViewerAction;
import net.sf.amemailchecker.mail.model.Letter;

abstract class MarkAction
extends MessageViewerAction {
    protected SelectionMode mode;

    protected MarkAction(MessageViewerContext messageViewerContext) {
        super(messageViewerContext);
    }

    protected MarkAction(String string, MessageViewerContext messageViewerContext, SelectionMode selectionMode) {
        super(string, messageViewerContext);
        this.mode = selectionMode;
    }

    protected void executeMark(MailServiceCommand mailServiceCommand, final Letter ... letterArray) {
        DefaultCommandExecutableTask defaultCommandExecutableTask = new DefaultCommandExecutableTask(mailServiceCommand);
        defaultCommandExecutableTask.addCommandErrorHandler(new CommandErrorHandler(){

            @Override
            public void handle(CommandExecutionException commandExecutionException) {
                MessageViewer.Viewer.getContext().getLettersTable().insert(false, letterArray);
            }
        });
        CommandExecutionService.Service.executeNotify(defaultCommandExecutableTask);
    }

    @Override
    public boolean isEnabled() {
        switch (this.mode) {
            case CHECKED: {
                return this.context.getLettersTable().getChecked(false).length > 0;
            }
            case SELECTED: {
                return this.context.getLettersTable().hasSelection();
            }
        }
        return !this.context.getLettersTable().empty();
    }

    protected void update(Letter ... letterArray) {
        this.context.getLettersTabbedPane().remove(letterArray);
        LettersTableMediator lettersTableMediator = this.context.getLettersTable();
        if (!lettersTableMediator.empty()) {
            lettersTableMediator.changeSelection(0);
            this.context.getLetterDetails().expandLetterDetails(lettersTableMediator.getSingle(false));
        }
        this.context.getLetterDetails().flush(letterArray);
        this.context.getFolderTree().refresh(this.context.getAccount());
    }
}

